/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableRunnable;
import com.sun.management.OperatingSystemMXBean;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean ourCompilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean ourOSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot myMemStart;
    private final FreeMemorySnapshot myMemEnd;
    private final long myCompilationTime;
    private final long myProcessTime;
    private final List<Pair<Long, String>> myGcTimes = new ArrayList<Pair<Long, String>>();
    private final List<Pair<Long, String>> myThreadTimes = new ArrayList<Pair<Long, String>>();

    private CpuUsageData(long durationMs, Object2LongMap<GarbageCollectorMXBean> gcTimes, Long2LongMap threadTimes, long compilationTime, long processTime, FreeMemorySnapshot memStart, FreeMemorySnapshot memEnd) {
        this.durationMs = durationMs;
        this.myMemStart = memStart;
        this.myMemEnd = memEnd;
        this.myCompilationTime = compilationTime;
        this.myProcessTime = processTime;
        Object2LongMaps.fastForEach(gcTimes, entry -> this.myGcTimes.add((Pair<Long, String>)Pair.create((Object)entry.getLongValue(), (Object)((GarbageCollectorMXBean)entry.getKey()).getName())));
        Long2LongMaps.fastForEach((Long2LongMap)threadTimes, entry -> {
            ThreadInfo info = ourThreadMXBean.getThreadInfo(entry.getLongKey());
            this.myThreadTimes.add((Pair<Long, String>)Pair.create((Object)CpuUsageData.toMillis(entry.getLongValue()), (Object)(info == null ? "<unknown>" : info.getThreadName())));
        });
    }

    public String getGcStats() {
        return CpuUsageData.printLongestNames(this.myGcTimes) + "; free " + this.myMemStart + " -> " + this.myMemEnd + " MB";
    }

    String getProcessCpuStats() {
        long gcTotal = this.myGcTimes.stream().mapToLong(p -> (Long)p.first).sum();
        return this.myCompilationTime + "ms JITc " + (gcTotal > 0L ? "and " + gcTotal + "ms GC " : "") + "of " + this.myProcessTime + "ms total";
    }

    public String getThreadStats() {
        return CpuUsageData.printLongestNames(this.myThreadTimes);
    }

    public String getSummary(String indent) {
        return indent + "GC: " + this.getGcStats() + "\n" + indent + "Threads: " + this.getThreadStats() + "\n" + indent + "Process: " + this.getProcessCpuStats();
    }

    boolean hasAnyActivityBesides(Thread thread) {
        return this.myCompilationTime > 0L || this.myThreadTimes.stream().anyMatch(pair -> (Long)pair.first > 0L && !((String)pair.second).equals(thread.getName())) || this.myGcTimes.stream().anyMatch(pair -> (Long)pair.first > 0L);
    }

    @NotNull
    private static String printLongestNames(List<Pair<Long, String>> times) {
        String stats = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).sortedBy(p -> -((Long)p.first).longValue())).filter(p -> (Long)p.first > 10L)).limit(10L)).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").joining((CharSequence)", ");
        return stats.isEmpty() ? "insignificant" : stats;
    }

    private static long toMillis(long timeNs) {
        return timeNs / 1000000L;
    }

    public static <E extends Throwable> CpuUsageData measureCpuUsage(ThrowableRunnable<E> runnable) throws E {
        FreeMemorySnapshot memStart = new FreeMemorySnapshot();
        Object2LongOpenHashMap gcTimes = new Object2LongOpenHashMap();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ourGcBeans) {
            gcTimes.put((Object)garbageCollectorMXBean, garbageCollectorMXBean.getCollectionTime());
        }
        Long2LongOpenHashMap threadTimes = new Long2LongOpenHashMap();
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id, ourThreadMXBean.getThreadUserTime(id));
        }
        long l = CpuUsageData.getTotalCompilationMillis();
        long processStart = ourOSBean.getProcessCpuTime();
        long start = System.nanoTime();
        runnable.run();
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long processTime = TimeUnit.NANOSECONDS.toMillis(ourOSBean.getProcessCpuTime() - processStart);
        long compTime = CpuUsageData.getTotalCompilationMillis() - l;
        FreeMemorySnapshot memEnd = new FreeMemorySnapshot();
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            threadTimes.put(id, ourThreadMXBean.getThreadUserTime(id) - threadTimes.get(id));
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            gcTimes.put((Object)bean, bean.getCollectionTime() - gcTimes.getLong((Object)bean));
        }
        return new CpuUsageData(duration, (Object2LongMap<GarbageCollectorMXBean>)gcTimes, (Long2LongMap)threadTimes, compTime, processTime, memStart, memEnd);
    }

    static long getTotalCompilationMillis() {
        return ourCompilationMXBean.getTotalCompilationTime();
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.toMb(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.toMb(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long toMb(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

