/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFile;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualLink
extends MockVirtualFile {
    private final VirtualFile myTarget;

    public MockVirtualLink(@NotNull String name, @Nullable VirtualFile target) {
        super(target != null && target.isDirectory(), name);
        this.myTarget = target;
    }

    public boolean is(@NotNull VFileProperty property) {
        return property == VFileProperty.SYMLINK || super.is(property);
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this.myTarget;
    }

    @Nullable
    public String getCanonicalPath() {
        return this.myTarget != null ? this.myTarget.getPath() : null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return this.myTarget != null ? this.myTarget.getChildren() : EMPTY_ARRAY;
    }

    @Override
    public void addChild(@NotNull MockVirtualFile child) {
        throw new UnsupportedOperationException();
    }
}

