/*
 * Decompiled with CFR 0.152.
 */
package com.appspot.cluestick_server.search;

import com.appspot.cluestick_server.search.SearchRequest;
import com.appspot.cluestick_server.search.SearchRequestInitializer;
import com.appspot.cluestick_server.search.model.EventReq;
import com.appspot.cluestick_server.search.model.SearchResponse;
import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

public class Search
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cluestick-server.appspot.com/_ah/api/";
    public static final String DEFAULT_SERVICE_PATH = "search/v1/";
    public static final String DEFAULT_BASE_URL = "https://cluestick-server.appspot.com/_ah/api/search/v1/";

    public Search(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Search(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Event event(EventReq content) throws IOException {
        Event result = new Event(content);
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public SearchOperation search() throws IOException {
        SearchOperation result = new SearchOperation();
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0-SNAPSHOT of the search library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Search.DEFAULT_ROOT_URL, Search.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Search build() {
            return new Search(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSearchRequestInitializer(SearchRequestInitializer searchRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)searchRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class SearchOperation
    extends SearchRequest<SearchResponse> {
        private static final String REST_PATH = "search";
        @Key
        private Boolean allContext;
        @Key
        private String env;
        @Key
        private Boolean hasIndex;
        @Key
        private String lang;
        @Key
        private Integer limit;
        @Key(value="package")
        private String package__;
        @Key
        private Boolean prefill;
        @Key
        private String sessionId;
        @Key
        private String symbol;
        @Key
        private String userAgent;

        protected SearchOperation() {
            super(Search.this, "GET", REST_PATH, null, SearchResponse.class);
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public SearchOperation setAlt(String alt) {
            return (SearchOperation)super.setAlt(alt);
        }

        public SearchOperation setFields(String fields) {
            return (SearchOperation)super.setFields(fields);
        }

        public SearchOperation setKey(String key) {
            return (SearchOperation)super.setKey(key);
        }

        public SearchOperation setOauthToken(String oauthToken) {
            return (SearchOperation)super.setOauthToken(oauthToken);
        }

        public SearchOperation setPrettyPrint(Boolean prettyPrint) {
            return (SearchOperation)super.setPrettyPrint(prettyPrint);
        }

        public SearchOperation setQuotaUser(String quotaUser) {
            return (SearchOperation)super.setQuotaUser(quotaUser);
        }

        public SearchOperation setUserIp(String userIp) {
            return (SearchOperation)super.setUserIp(userIp);
        }

        public Boolean getAllContext() {
            return this.allContext;
        }

        public SearchOperation setAllContext(Boolean allContext) {
            this.allContext = allContext;
            return this;
        }

        public String getEnv() {
            return this.env;
        }

        public SearchOperation setEnv(String env) {
            this.env = env;
            return this;
        }

        public Boolean getHasIndex() {
            return this.hasIndex;
        }

        public SearchOperation setHasIndex(Boolean hasIndex) {
            this.hasIndex = hasIndex;
            return this;
        }

        public String getLang() {
            return this.lang;
        }

        public SearchOperation setLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public SearchOperation setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public String getPackage() {
            return this.package__;
        }

        public SearchOperation setPackage(String package__) {
            this.package__ = package__;
            return this;
        }

        public Boolean getPrefill() {
            return this.prefill;
        }

        public SearchOperation setPrefill(Boolean prefill) {
            this.prefill = prefill;
            return this;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public SearchOperation setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public SearchOperation setSymbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public SearchOperation setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public SearchOperation set(String parameterName, Object value) {
            return (SearchOperation)super.set(parameterName, value);
        }
    }

    public class Event
    extends SearchRequest<Void> {
        private static final String REST_PATH = "event";

        protected Event(EventReq content) {
            super(Search.this, "POST", REST_PATH, (Object)content, Void.class);
        }

        public Event setAlt(String alt) {
            return (Event)super.setAlt(alt);
        }

        public Event setFields(String fields) {
            return (Event)super.setFields(fields);
        }

        public Event setKey(String key) {
            return (Event)super.setKey(key);
        }

        public Event setOauthToken(String oauthToken) {
            return (Event)super.setOauthToken(oauthToken);
        }

        public Event setPrettyPrint(Boolean prettyPrint) {
            return (Event)super.setPrettyPrint(prettyPrint);
        }

        public Event setQuotaUser(String quotaUser) {
            return (Event)super.setQuotaUser(quotaUser);
        }

        public Event setUserIp(String userIp) {
            return (Event)super.setUserIp(userIp);
        }

        @Override
        public Event set(String parameterName, Object value) {
            return (Event)super.set(parameterName, value);
        }
    }
}

