/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import java.util.function.Consumer;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.kpmsearch.PackageServiceConfig;

class MyErrorHandler<T>
implements Consumer<Throwable> {
    private long myLastFailureTime = -1L;
    private Throwable myThrowable;
    private int attemps = 0;

    MyErrorHandler() {
    }

    @Override
    public synchronized void accept(Throwable throwable) {
        if (this.attemps == 0) {
            this.myThrowable = throwable;
        }
        ++this.attemps;
        this.myLastFailureTime = System.currentTimeMillis();
    }

    private boolean isDown() {
        long timeToCheck;
        boolean stillDown;
        if (this.myLastFailureTime == -1L) {
            return false;
        }
        double value = Math.pow(PackageServiceConfig.BACKOFF_MULTIPLIER, this.attemps) * (double)PackageServiceConfig.INITIAL_TIMEOUT + (double)this.myLastFailureTime;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            value = this.myLastFailureTime + PackageServiceConfig.MAX_TIMEOUT;
        }
        boolean bl = stillDown = (timeToCheck = (long)value) >= System.currentTimeMillis();
        if (!stillDown) {
            this.markSuccess();
            return false;
        }
        return true;
    }

    public synchronized Promise<Void> errorResult() {
        if (!this.isDown()) {
            return null;
        }
        AsyncPromise error = new AsyncPromise();
        error.onError(r -> {});
        error.setError(this.myThrowable);
        return error;
    }

    public synchronized void markSuccess() {
        this.myLastFailureTime = -1L;
        this.attemps = 0;
    }
}

