/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoaderCacheIO;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SVGLoaderPrebuilt {
    @NotNull
    @ApiStatus.Internal
    public static String getPreBuiltImageURLSuffix(double scale) {
        return "-" + scale + ".jpix";
    }

    @Nullable
    public static URL preBuiltImageURL(@Nullable URL url, double scale) {
        if (url == null) {
            return null;
        }
        try {
            if (!url.getFile().endsWith("svg")) {
                return null;
            }
            if (url.getQuery() != null) {
                return null;
            }
            if (url.getRef() != null) {
                return null;
            }
            if (!url.getProtocol().equalsIgnoreCase("jar") && !url.getProtocol().equalsIgnoreCase("file")) {
                return null;
            }
            return new URL(url, url.toString() + SVGLoaderPrebuilt.getPreBuiltImageURLSuffix(scale));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ApiStatus.Internal
    public static BufferedImage loadUrlFromPreBuiltCache(@Nullable URL url, double scale, @NotNull ImageLoader.Dimension2DDouble docSize) {
        long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
        URL lookupUrl = SVGLoaderPrebuilt.preBuiltImageURL(url, scale);
        if (lookupUrl == null) {
            return null;
        }
        try (InputStream is = lookupUrl.openStream();){
            BufferedImage result = SVGLoaderCacheIO.readImageFile(FileUtil.loadBytes((InputStream)is), docSize);
            IconLoadMeasurer.svgPreBuiltLoad.addDurationStartedAt(start);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        catch (Exception e) {
            return null;
        }
    }
}

