/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;

public final class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, (ImageObserver)ImageLoader.ourComponent);
    }

    @Deprecated
    @NotNull
    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        return RetinaImage.createFrom(image, (double)scale, observer);
    }

    @NotNull
    public static Image createFrom(@NotNull Image image, double scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        return new JBHiDPIScaledImage(image, (double)w / scale, (double)h / scale, 2);
    }

    @NotNull
    public static BufferedImage create(int width, int height, int type) {
        return new JBHiDPIScaledImage(width, height, type);
    }

    @NotNull
    public static BufferedImage create(Graphics2D g, int width, int height, int type) {
        return new JBHiDPIScaledImage(g, width, height, type);
    }

    @NotNull
    public static BufferedImage create(Graphics2D g, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        return new JBHiDPIScaledImage(g, width, height, type, rm);
    }

    @NotNull
    public static BufferedImage create(GraphicsConfiguration gc, int width, int height, int type) {
        return new JBHiDPIScaledImage(gc, width, height, type);
    }

    @NotNull
    public static BufferedImage create(GraphicsConfiguration gc, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        return new JBHiDPIScaledImage(gc, width, height, type, rm);
    }

    @NotNull
    public static BufferedImage create(ScaleContext ctx, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        return new JBHiDPIScaledImage(ctx, width, height, type, rm);
    }
}

