/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageType;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImageDescriptor {
    private static final ConcurrentMap<String, Pair<Image, ImageLoader.Dimension2DDouble>> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    private static final ConcurrentMap<String, Image> ourLargeImageCache = ContainerUtil.createConcurrentWeakValueMap();
    private static final ConcurrentMap<Image, ImageLoader.Dimension2DDouble> ourLargeImageDimensionMap = CollectionFactory.createConcurrentWeakMap();
    @NotNull
    final String path;
    public final double scale;
    @NotNull
    public final ImageType type;
    final boolean original;
    @NotNull
    public final ImageLoader.Dimension2DDouble origUsrSize;
    @Nullable
    static volatile LoadTimeConsumer loadTimeConsumer;

    public ImageDescriptor(@NotNull String path, double scale, @NotNull ImageType type) {
        this(path, scale, type, false);
    }

    public ImageDescriptor(double scale) {
        this("", scale, ImageType.IMG, false);
    }

    public static void setLoadTimeConsumer(@Nullable LoadTimeConsumer loadTimeConsumer) {
        ImageDescriptor.loadTimeConsumer = loadTimeConsumer;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance((String)"#com.intellij.util.ImageLoader");
    }

    public static void clearCache() {
        ourCache.clear();
        ourLargeImageCache.clear();
        ourLargeImageDimensionMap.clear();
        ImageLoader.clearCache();
    }

    public ImageDescriptor(@NotNull String path, double scale, @NotNull ImageType type, boolean original) {
        this.path = path;
        this.scale = scale;
        this.type = type;
        this.original = original;
        this.origUsrSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public Image load(boolean useCache) throws IOException {
        return this.load(useCache, null);
    }

    @Nullable
    public Image load(boolean useCache, @Nullable Class<?> resourceClass) throws IOException {
        long start;
        if (StringUtilRt.isEmpty((CharSequence)this.path)) {
            ImageDescriptor.getLogger().warn("empty image path", new Throwable());
            return null;
        }
        String cacheKey = null;
        if (useCache) {
            ImageLoader.Dimension2DDouble dimension;
            cacheKey = this.path + (this.type == ImageType.SVG ? "_@" + this.scale + "x" : "");
            Pair pair = (Pair)ourCache.get(cacheKey);
            if (pair != null) {
                this.origUsrSize.setSize((ImageLoader.Dimension2DDouble)pair.second);
                return (Image)pair.first;
            }
            Image image = (Image)ourLargeImageCache.get(cacheKey);
            if (image != null && (dimension = (ImageLoader.Dimension2DDouble)ourLargeImageDimensionMap.get(image)) != null) {
                this.origUsrSize.setSize(dimension);
                return image;
            }
        }
        long l = start = StartUpMeasurer.isEnabled() || loadTimeConsumer != null ? StartUpMeasurer.getCurrentTime() : -1L;
        if (resourceClass != null) {
            Image image;
            InputStream stream = resourceClass.getResourceAsStream(this.path);
            Image image2 = image = stream == null ? null : this.loadFromStream(stream, resourceClass.getResource(this.path), cacheKey);
            if (start != -1L) {
                IconLoadMeasurer.addLoadFromResources(StartUpMeasurer.getCurrentTime() - start);
            }
            return image;
        }
        URL url = new URL(this.path);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            if (!this.original) {
                return null;
            }
            connection.addRequestProperty("User-Agent", "IntelliJ");
        }
        Image image = this.loadFromStream(connection.getInputStream(), url, cacheKey);
        if (start != -1L) {
            IconLoadMeasurer.addLoadFromUrl(StartUpMeasurer.getCurrentTime() - start);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Image loadFromStream(@NotNull InputStream stream, @Nullable URL url, @Nullable String cacheKey) throws IOException {
        Image image;
        try {
            image = this.loadImpl(url, stream);
        }
        finally {
            stream.close();
        }
        if (image != null && cacheKey != null) {
            if (4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                ourCache.put(cacheKey, (Pair<Image, ImageLoader.Dimension2DDouble>)Pair.create((Object)image, (Object)this.origUsrSize));
            } else {
                ourLargeImageCache.put(cacheKey, image);
                ourLargeImageDimensionMap.put(image, this.origUsrSize);
            }
        }
        return image;
    }

    @Nullable
    private Image loadImpl(@Nullable URL url, @NotNull InputStream stream) throws IOException {
        Image image;
        LoadTimeConsumer loadTimeConsumer = ImageDescriptor.loadTimeConsumer;
        long start = StartUpMeasurer.isEnabled() || loadTimeConsumer != null ? StartUpMeasurer.getCurrentTime() : -1L;
        switch (this.type) {
            case SVG: {
                image = SVGLoader.load(url, stream, this.scale, this.origUsrSize);
                break;
            }
            case IMG: {
                image = this.loadImpl(stream);
                break;
            }
            default: {
                return null;
            }
        }
        if (start != -1L) {
            int duration = (int)(StartUpMeasurer.getCurrentTime() - start);
            IconLoadMeasurer.addDecoding(this.type, duration);
            if (loadTimeConsumer != null) {
                loadTimeConsumer.accept(this.type, duration);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Image loadImpl(@NotNull InputStream stream) {
        try {
            Image image;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (stream instanceof BufferExposingByteArrayInputStream) {
                BufferExposingByteArrayInputStream byteInput = (BufferExposingByteArrayInputStream)stream;
                image = toolkit.createImage(byteInput.getInternalBuffer(), 0, byteInput.available());
            } else {
                BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
                try {
                    FileUtilRt.copy((InputStream)stream, (OutputStream)outputStream);
                }
                finally {
                    stream.close();
                }
                image = toolkit.createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            }
            ImageDescriptor.waitForImage(image);
            this.origUsrSize.setSize((double)image.getWidth(null) / this.scale, (double)image.getHeight(null) / this.scale);
            return image;
        }
        catch (Exception ex) {
            ImageDescriptor.getLogger().error((Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ImageLoader.ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            ImageDescriptor.getLogger().info((Throwable)ex);
        }
        return !mediatracker.isErrorID(1);
    }

    public static interface LoadTimeConsumer {
        public void accept(@NotNull ImageType var1, int var2);
    }
}

