/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.batch;

import com.intellij.codeInspection.i18n.batch.I18nizedPropertyData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ItemRemovable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeMultipleStringsDialog<D>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(I18nizeMultipleStringsDialog.class);
    @NonNls
    private static final String LAST_USED_PROPERTIES_FILE = "LAST_USED_PROPERTIES_FILE";
    @NonNls
    private static final String LAST_USED_CONTEXT = "I18N_FIX_LAST_USED_CONTEXT";
    @NotNull
    private final Project myProject;
    private final List<I18nizedPropertyData<D>> myKeyValuePairs;
    private final Function<D, List<UsageInfo>> myUsagePreviewProvider;
    private final Set<Module> myContextModules;
    @Nullable
    private final ResourceBundleManager myResourceBundleManager;
    private JComboBox<String> myPropertiesFile;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JBTable myTable;
    private final Icon myMarkAsNonNlsButtonIcon;

    public I18nizeMultipleStringsDialog(@NotNull Project project, @NotNull List<I18nizedPropertyData<D>> keyValuePairs, @NotNull Set<PsiFile> contextFiles, @NotNull Function<D, List<UsageInfo>> usagePreviewProvider, Icon markAsNonNlsButtonIcon) {
        super(project, true);
        ResourceBundleManager resourceBundleManager;
        this.myProject = project;
        this.myKeyValuePairs = keyValuePairs;
        this.myUsagePreviewProvider = usagePreviewProvider;
        try {
            resourceBundleManager = ResourceBundleManager.getManager(contextFiles, project);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            LOG.error((Throwable)e);
            resourceBundleManager = null;
        }
        this.myResourceBundleManager = resourceBundleManager;
        this.myMarkAsNonNlsButtonIcon = markAsNonNlsButtonIcon;
        this.myContextModules = contextFiles.stream().map(ModuleUtilCore::findModuleForFile).filter(Objects::nonNull).collect(Collectors.toSet());
        this.setTitle(PropertiesBundle.message((String)"i18nize.multiple.strings.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "i18nInBatch";
    }

    @Nullable
    protected JComponent createNorthPanel() {
        List files = this.myResourceBundleManager != null ? this.myResourceBundleManager.suggestPropertiesFiles(this.myContextModules) : I18nUtil.defaultSuggestPropertiesFiles((Project)this.myProject, this.myContextModules);
        this.myPropertiesFile = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)files));
        new ComboboxSpeedSearch(this.myPropertiesFile);
        LabeledComponent component = new LabeledComponent();
        component.setText(JavaI18nBundle.message("property.file", new Object[0]));
        component.setComponent(this.myPropertiesFile);
        this.myPropertiesFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesFile propertiesFile = I18nizeMultipleStringsDialog.this.getPropertiesFile();
                if (propertiesFile != null) {
                    for (int i = 0; i < I18nizeMultipleStringsDialog.this.myKeyValuePairs.size(); ++i) {
                        I18nizedPropertyData data = (I18nizedPropertyData)I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(i);
                        I18nizedPropertyData updated = data.changeKey(I18nizeQuickFixDialog.suggestUniquePropertyKey((String)data.getValue(), (String)data.getKey(), (PropertiesFile)propertiesFile));
                        I18nizeMultipleStringsDialog.this.myKeyValuePairs.set(i, updated);
                    }
                }
            }
        });
        if (!files.isEmpty()) {
            String contextString = this.getContextString();
            String preselectedFile = contextString != null && contextString.equals(PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_CONTEXT)) ? PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_PROPERTIES_FILE) : null;
            this.myPropertiesFile.setSelectedItem(ObjectUtils.notNull(preselectedFile, files.get(0)));
        }
        return component;
    }

    public PropertiesFile getPropertiesFile() {
        Object selectedItem = this.myPropertiesFile.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)((String)selectedItem));
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile != null ? PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) : null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBSplitter splitter = new JBSplitter(true);
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
        this.myTable = new JBTable((TableModel)new MyKeyValueModel());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.putClientProperty("html.disable", Boolean.TRUE);
        this.myTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.myTable.getSelectionModel().addListSelectionListener(e -> this.updateUsagePreview(this.myTable));
        AnActionButtonRunnable removeAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)I18nizeMultipleStringsDialog.this.myTable);
                I18nizeMultipleStringsDialog.this.myTable.repaint();
                I18nizeMultipleStringsDialog.this.updateUsagePreview(I18nizeMultipleStringsDialog.this.myTable);
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setRemoveAction(removeAction);
        if (this.myMarkAsNonNlsButtonIcon != null) {
            AnActionButton markAsNonNls = new AnActionButton(JavaI18nBundle.message("action.text.mark.as.nonnls", new Object[0]), this.myMarkAsNonNlsButtonIcon){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    TableUtil.stopEditing((JTable)I18nizeMultipleStringsDialog.this.myTable);
                    List selection = I18nizeMultipleStringsDialog.this.getSelectedDataWithIndices();
                    boolean mark = this.shouldMarkAsNonNls(selection);
                    for (Pair dataWithIndex : selection) {
                        I18nizeMultipleStringsDialog.this.myKeyValuePairs.set((Integer)dataWithIndex.first, ((I18nizedPropertyData)dataWithIndex.second).setMarkAsNonNls(mark));
                    }
                    I18nizeMultipleStringsDialog.this.myTable.repaint();
                }

                public void updateButton(@NotNull AnActionEvent e) {
                    List selection = I18nizeMultipleStringsDialog.this.getSelectedDataWithIndices();
                    e.getPresentation().setEnabled(!selection.isEmpty());
                    e.getPresentation().setText(this.shouldMarkAsNonNls(selection) ? JavaI18nBundle.message("action.text.mark.as.nonnls", new Object[0]) : JavaI18nBundle.message("action.text.unmark.as.nonnls", new Object[0]));
                }

                private boolean shouldMarkAsNonNls(List<Pair<Integer, I18nizedPropertyData<D>>> selection) {
                    return !selection.stream().allMatch(data -> ((I18nizedPropertyData)data.second).isMarkAsNonNls());
                }
            };
            markAsNonNls.setShortcut((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(78, 512)));
            decorator.addExtraAction(markAsNonNls);
        }
        splitter.setFirstComponent((JComponent)decorator.createPanel());
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        return splitter;
    }

    @NotNull
    private List<Pair<Integer, I18nizedPropertyData<D>>> getSelectedDataWithIndices() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<Pair<Integer, I18nizedPropertyData<D>>> selection = new ArrayList<Pair<Integer, I18nizedPropertyData<D>>>(rows.length);
        for (int row : rows) {
            if (0 > row || row >= this.myKeyValuePairs.size()) continue;
            selection.add(Pair.create((Object)row, this.myKeyValuePairs.get(row)));
        }
        return selection;
    }

    private void updateUsagePreview(JBTable table) {
        int index = table.getSelectionModel().getLeadSelectionIndex();
        if (index != -1) {
            this.myUsagePreviewPanel.updateLayout(this.myUsagePreviewProvider.apply(this.myKeyValuePairs.get(index).getContextData()));
        } else {
            this.myUsagePreviewPanel.updateLayout(null);
        }
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_PROPERTIES_FILE, (String)this.myPropertiesFile.getSelectedItem());
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_CONTEXT, this.getContextString());
        super.doOKAction();
    }

    @Nullable
    private String getContextString() {
        return this.myContextModules.stream().map(Module::getName).min(Comparator.naturalOrder()).orElse(null);
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    private class MyKeyValueModel
    extends AbstractTableModel
    implements ItemRemovable {
        private MyKeyValueModel() {
        }

        @Override
        public int getRowCount() {
            return I18nizeMultipleStringsDialog.this.myKeyValuePairs.size();
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Key" : "Value";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && 0 <= rowIndex && rowIndex < I18nizeMultipleStringsDialog.this.myKeyValuePairs.size() && !((I18nizedPropertyData)I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex)).isMarkAsNonNls();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            I18nizedPropertyData data = (I18nizedPropertyData)I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex);
            if (columnIndex == 0) {
                return data.isMarkAsNonNls() ? "will be marked as NonNls" : data.getKey();
            }
            return data.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                I18nizedPropertyData bean = (I18nizedPropertyData)I18nizeMultipleStringsDialog.this.myKeyValuePairs.get(rowIndex);
                I18nizeMultipleStringsDialog.this.myKeyValuePairs.set(rowIndex, bean.changeKey((String)aValue));
            }
        }

        public void removeRow(int idx) {
            I18nizeMultipleStringsDialog.this.myKeyValuePairs.remove(idx);
        }
    }
}

