/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ArrayTypeImpl;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.ValueContainer;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    private volatile int length = -1;

    ArrayReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    protected ClassTypeImpl invokableReferenceType(Method method) {
        return (ClassTypeImpl)method.declaringType();
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    @Override
    public int length() {
        if (this.length == -1) {
            try {
                this.length = JDWP.ArrayReference.Length.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this).arrayLength;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.length;
    }

    public CompletableFuture<Integer> lengthAsync() {
        if (this.length != -1) {
            return CompletableFuture.completedFuture(this.length);
        }
        return JDWP.ArrayReference.Length.processAsync(this.vm, this).thenApply(r -> {
            this.length = r.arrayLength;
            return this.length;
        });
    }

    void setLength(int length) {
        this.length = length;
    }

    @Override
    public Value getValue(int index) {
        return this.getValues(index, 1).get(0);
    }

    public CompletableFuture<Value> getValueAsync(int index) {
        return this.getValuesAsync(index, 1).thenApply(r -> (Value)r.get(0));
    }

    @Override
    public List<Value> getValues() {
        return this.getValues(0, -1);
    }

    public CompletableFuture<List<Value>> getValuesAsync() {
        return this.getValuesAsync(0, -1);
    }

    private void validateArrayAccess(int index, int length) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + index);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + length);
        }
        if (index + length > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + index + " to " + (index + length - 1));
        }
    }

    private static <T> T cast(Object x) {
        return (T)x;
    }

    public CompletableFuture<List<Value>> getValuesAsync(int index, int len) {
        return this.lengthAsync().thenCompose(__ -> {
            int length = len;
            if (length == -1) {
                length = this.length() - index;
            }
            this.validateArrayAccess(index, length);
            if (length == 0) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return JDWP.ArrayReference.GetValues.processAsync(this.vm, this, index, length).thenApply(r -> (List)ArrayReferenceImpl.cast(r.values));
        });
    }

    @Override
    public List<Value> getValues(int index, int length) {
        List vals;
        if (length == -1) {
            length = this.length() - index;
        }
        this.validateArrayAccess(index, length);
        if (length == 0) {
            return Collections.emptyList();
        }
        try {
            vals = (List)ArrayReferenceImpl.cast(JDWP.ArrayReference.GetValues.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this, (int)index, (int)length).values);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return vals;
    }

    @Override
    public void setValue(int index, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(index, Collections.singletonList(value), 0, 1);
    }

    @Override
    public void setValues(List<? extends Value> values) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, values, 0, -1);
    }

    @Override
    public void setValues(int index, List<? extends Value> values, int srcIndex, int length) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(index, values, srcIndex, length, true);
    }

    public void setValues(int index, List<? extends Value> values, int srcIndex, int length, boolean checkAssignable) throws InvalidTypeException, ClassNotLoadedException {
        if (length == -1) {
            length = Math.min(this.length() - index, values.size() - srcIndex);
        }
        this.validateMirrorsOrNulls(values);
        this.validateArrayAccess(index, length);
        if (srcIndex < 0 || srcIndex > values.size()) {
            throw new IndexOutOfBoundsException("Invalid source index: " + srcIndex);
        }
        if (srcIndex + length > values.size()) {
            throw new IndexOutOfBoundsException("Invalid source range: " + srcIndex + " to " + (srcIndex + length - 1));
        }
        boolean somethingToSet = false;
        ValueImpl[] setValues = new ValueImpl[length];
        for (int i = 0; i < length; ++i) {
            ValueImpl value = (ValueImpl)values.get(srcIndex + i);
            try {
                setValues[i] = ArrayReferenceImpl.prepareForAssignment(value, new Component(checkAssignable));
                somethingToSet = true;
                continue;
            }
            catch (ClassNotLoadedException e) {
                if (value == null) continue;
                throw e;
            }
        }
        if (somethingToSet) {
            try {
                JDWP.ArrayReference.SetValues.process(this.vm, this, index, setValues);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 91;
    }

    @Override
    void validateAssignment(ValueContainer destination) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            try {
                super.validateAssignment(destination);
            }
            catch (ClassNotLoadedException e) {
                boolean valid = false;
                JNITypeParser destParser = new JNITypeParser(destination.signature());
                JNITypeParser srcParser = new JNITypeParser(this.arrayType().signature());
                int destDims = destParser.dimensionCount();
                if (destDims <= srcParser.dimensionCount()) {
                    String destComponentSignature = destParser.componentSignature(destDims);
                    Type destComponentType = destination.findType(destComponentSignature);
                    String srcComponentSignature = srcParser.componentSignature(destDims);
                    Type srcComponentType = this.arrayType().findComponentType(srcComponentSignature);
                    valid = ArrayTypeImpl.isComponentAssignable(destComponentType, srcComponentType);
                }
                if (valid) break block3;
                throw new InvalidTypeException("Cannot assign " + this.arrayType().name() + " to " + destination.typeName());
            }
        }
    }

    class Component
    implements ValueContainer {
        private final boolean checkAssignable;

        public Component(boolean checkAssignable) {
            this.checkAssignable = checkAssignable;
        }

        @Override
        public Type type() throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().componentType();
        }

        @Override
        public String typeName() {
            return ArrayReferenceImpl.this.arrayType().componentTypeName();
        }

        @Override
        public String signature() {
            return ArrayReferenceImpl.this.arrayType().componentSignature();
        }

        @Override
        public Type findType(String signature) throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().findComponentType(signature);
        }

        @Override
        public boolean checkAssignable() {
            return this.checkAssignable;
        }
    }
}

