/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistStorageProvider;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SensitiveDataValidator {
    private static final ConcurrentMap<String, SensitiveDataValidator> ourInstances = new ConcurrentHashMap<String, SensitiveDataValidator>();
    @NotNull
    protected final WhitelistGroupRulesStorage myWhiteListStorage;

    @NotNull
    public static SensitiveDataValidator getInstance(@NotNull String recorderId) {
        return ourInstances.computeIfAbsent(recorderId, id -> {
            WhitelistGroupRulesStorage whitelistStorage = WhitelistStorageProvider.newStorage(recorderId);
            return ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator(whitelistStorage) : new SensitiveDataValidator(whitelistStorage);
        });
    }

    @Nullable
    public static SensitiveDataValidator getIfInitialized(@NotNull String recorderId) {
        return (SensitiveDataValidator)ourInstances.get(recorderId);
    }

    protected SensitiveDataValidator(@NotNull WhitelistGroupRulesStorage storage) {
        this.myWhiteListStorage = storage;
    }

    public WhitelistGroupRulesStorage getWhiteListStorage() {
        return this.myWhiteListStorage;
    }

    public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
        if (this.myWhiteListStorage.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_METADATA.getDescription();
        }
        if (EventLogSystemEvents.SYSTEM_EVENTS.contains(context.eventId)) {
            return context.eventId;
        }
        ValidationResultType validationResultType = this.validateEvent(group, context);
        return validationResultType == ValidationResultType.ACCEPTED ? context.eventId : validationResultType.getDescription();
    }

    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
        boolean containsPluginInfo;
        EventGroupRules groupRules = this.myWhiteListStorage.getGroupRules(group.getId());
        if (SensitiveDataValidator.isTestModeEnabled(groupRules)) {
            return context.eventData;
        }
        ConcurrentHashMap<String, Object> validatedData = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : context.eventData.entrySet()) {
            String key = entry.getKey();
            Object entryValue = entry.getValue();
            validatedData.put(key, this.validateEventData(context, groupRules, key, entryValue));
        }
        boolean bl = containsPluginInfo = validatedData.containsKey("plugin") || validatedData.containsKey("plugin_type") || validatedData.containsKey("plugin_version");
        if (context.pluginInfo != null && !containsPluginInfo) {
            StatisticsUtilKt.addPluginInfoTo(context.pluginInfo, validatedData);
        }
        return validatedData;
    }

    private static boolean isTestModeEnabled(@Nullable EventGroupRules rule) {
        return TestModeValidationRule.isTestModeEnabled() && rule != null && Arrays.stream(rule.getEventIdRules()).anyMatch(r -> r instanceof TestModeValidationRule);
    }

    public ValidationResultType validateEvent(@NotNull EventLogGroup group, @NotNull EventContext context) {
        EventGroupRules groupRules = this.myWhiteListStorage.getGroupRules(group.getId());
        if (groupRules == null || !groupRules.areEventIdRulesDefined()) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return groupRules.validateEventId(context);
    }

    private Object validateEventData(@NotNull EventContext context, @Nullable EventGroupRules groupRules, @NotNull String key, @NotNull Object entryValue) {
        if (this.myWhiteListStorage.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_METADATA;
        }
        if (groupRules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return groupRules.validateEventData(key, entryValue, context);
    }

    public void update() {
        this.myWhiteListStorage.update();
    }

    public void reload() {
        this.myWhiteListStorage.reload();
    }

    static {
        CustomValidationRule.EP_NAME.addChangeListener(ourInstances::clear, null);
        CustomWhiteListRule.EP_NAME.addChangeListener(ourInstances::clear, null);
    }

    private static class BlindSensitiveDataValidator
    extends SensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull WhitelistGroupRulesStorage whiteListStorage) {
            super(whiteListStorage);
        }

        @Override
        public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
            return context.eventId;
        }

        @Override
        public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
            return context.eventData;
        }
    }
}

