/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.collectors.fus.ActionPlaceHolder;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataBuilder;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataKt;
import com.intellij.internal.statistic.eventLog.ShortcutDataProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 H2\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0012\u0010\b\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\u0005H\u0007J\u0014\u0010\n\u001a\u00020\u00002\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0018J\u0018\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0019J\u0018\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001aJ\u0018\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0013J\u0018\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001bJ\u001a\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0018H\u0007J\u0012\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001e\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010#2\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020%H\u0007J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020&H\u0007J\u0012\u0010'\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0014\u0010'\u001a\u00020\u00002\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J1\u0010*\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010+0\u001cH\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u0000H\u0007J+\u0010.\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010+H\u0000\u00a2\u0006\u0002\b/J\u0014\u00100\u001a\u00020\u00002\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u00101\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u000103H\u0007J\u0010\u00104\u001a\u00020\u00002\b\u00105\u001a\u0004\u0018\u000106J\u0010\u00107\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0001H\u0007J\u0014\u00108\u001a\u00020\u00002\n\b\u0001\u00109\u001a\u0004\u0018\u00010:H\u0007J\u0014\u0010;\u001a\u00020\u00002\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010+J\u0006\u0010=\u001a\u00020\u0000J\u0013\u0010>\u001a\u00020\u00182\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010@\u001a\u00020\u0005H\u0002J\b\u0010A\u001a\u00020\u0013H\u0016J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0018\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00002\b\b\u0001\u0010E\u001a\u00020\u0005J\u0010\u0010F\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010G\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "", "()V", "data", "", "", "addAll", "from", "addAnonymizedId", "id", "addAnonymizedPath", "path", "addAnonymizedValue", "key", "value", "addClientId", "clientId", "addCount", "count", "", "addCurrentFile", "language", "Lcom/intellij/lang/Language;", "addData", "", "", "", "", "", "addDataInternal", "addEnabled", "enabled", "addInputEvent", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Ljava/awt/event/InputEvent;", "place", "Ljava/awt/event/KeyEvent;", "Ljava/awt/event/MouseEvent;", "addLanguage", "addLanguageInternal", "fieldName", "addListObjectData", "", "addListObjectData$intellij_platform_statistics", "addOS", "addObjectData", "addObjectData$intellij_platform_statistics", "addPlace", "addPluginInfo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "addProject", "project", "Lcom/intellij/openapi/project/Project;", "addValue", "addVersion", "version", "Lcom/intellij/openapi/util/Version;", "addVersionByString", "build", "copy", "equals", "other", "getOS", "hashCode", "isCommonPlace", "merge", "next", "prefix", "parsePermanentClientId", "toString", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class FeatureUsageData {
    private Map<String, Object> data = new HashMap();
    @NotNull
    private static final List<String> platformDataKeys;
    public static final Companion Companion;

    @NotNull
    public final FeatureUsageData addClientId(@Nullable String clientId) {
        block0: {
            String string = clientId;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String permanentClientId = this.parsePermanentClientId(clientId);
            this.data.put("client_id", EventLogConfiguration.INSTANCE.anonymize(permanentClientId));
        }
        return this;
    }

    private final String parsePermanentClientId(String clientId) {
        int separator = StringsKt.indexOf$default((CharSequence)clientId, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (separator > 0) {
            String string = clientId;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return clientId;
    }

    @NotNull
    public final FeatureUsageData addProject(@Nullable Project project) {
        if (project != null) {
            this.data.put("project", StatisticsUtil.getProjectId(project));
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"version:regexp#version"})
    @NotNull
    public final FeatureUsageData addVersionByString(@NonNls @Nullable String version) {
        if (version == null) {
            this.data.put("version", "unknown");
        } else {
            this.addVersion(Version.parseVersion((String)version));
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"version:regexp#version"})
    @NotNull
    public final FeatureUsageData addVersion(@NonNls @Nullable Version version) {
        this.data.put("version", version != null ? "" + version.major + '.' + version.minor : "unknown.format");
        return this;
    }

    @Deprecated(message="Don't add OS to event data")
    @FeatureUsageDataBuilder(additionalDataFields={"os:enum#os"})
    @NotNull
    public final FeatureUsageData addOS() {
        this.data.put("os", this.getOS());
        return this;
    }

    private final String getOS() {
        if (SystemInfo.isWindows) {
            return "Windows";
        }
        if (SystemInfo.isMac) {
            return "Mac";
        }
        return SystemInfo.isLinux ? "Linux" : "Other";
    }

    @FeatureUsageDataBuilder(additionalDataFields={"plugin:util#plugin", "plugin_type:util#plugin_type", "plugin_version:util#plugin_version"})
    @NotNull
    public final FeatureUsageData addPluginInfo(@Nullable PluginInfo info) {
        block0: {
            PluginInfo pluginInfo = info;
            if (pluginInfo == null) break block0;
            PluginInfo pluginInfo2 = pluginInfo;
            boolean bl = false;
            boolean bl2 = false;
            PluginInfo it = pluginInfo2;
            boolean bl3 = false;
            StatisticsUtilKt.addPluginInfoTo(info, this.data);
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"lang:util#lang"})
    @NotNull
    public final FeatureUsageData addLanguage(@NonNls @Nullable String id) {
        block0: {
            String string = id;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.addLanguage(Language.findLanguageByID((String)id));
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"lang:util#lang"})
    @NotNull
    public final FeatureUsageData addLanguage(@Nullable Language language) {
        return this.addLanguageInternal("lang", language);
    }

    @FeatureUsageDataBuilder(additionalDataFields={"current_file:util#current_file"})
    @NotNull
    public final FeatureUsageData addCurrentFile(@Nullable Language language) {
        return this.addLanguageInternal("current_file", language);
    }

    private final FeatureUsageData addLanguageInternal(String fieldName, Language language) {
        block2: {
            Language language2 = language;
            if (language2 == null) break block2;
            Language language3 = language2;
            boolean bl = false;
            boolean bl2 = false;
            Language it = language3;
            boolean bl3 = false;
            PluginInfo type = PluginInfoDetectorKt.getPluginInfo(language.getClass());
            if (type.isSafeToReport()) {
                this.data.put(fieldName, language.getID());
            } else {
                this.data.put(fieldName, "third.party");
            }
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"input_event:util#shortcut"})
    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable InputEvent event, @NonNls @Nullable String place) {
        String inputEvent = ShortcutDataProvider.getInputEventText(event, place);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"input_event:util#shortcut"})
    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable AnActionEvent event) {
        String inputEvent = ShortcutDataProvider.getActionEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"input_event:util#shortcut"})
    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull KeyEvent event) {
        String inputEvent = ShortcutDataProvider.getKeyEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"input_event:util#shortcut"})
    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull MouseEvent event) {
        String inputEvent = ShortcutDataProvider.getMouseEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"place:util#place"})
    @NotNull
    public final FeatureUsageData addPlace(@NonNls @Nullable String place) {
        if (place == null) {
            return this;
        }
        String reported = "unknown";
        if (this.isCommonPlace(place) || ActionPlaceHolder.isCustomActionPlace(place)) {
            reported = place;
        } else if (ActionPlaces.isPopupPlace((String)place)) {
            reported = "popup";
        }
        this.data.put("place", reported);
        return this;
    }

    private final boolean isCommonPlace(String place) {
        return ActionPlaces.isCommonPlace((String)place) || Intrinsics.areEqual((Object)"ToolwindowPopup", (Object)place);
    }

    @FeatureUsageDataBuilder(additionalDataFields={"file_path:util#hash"})
    @NotNull
    public final FeatureUsageData addAnonymizedPath(@NonNls @Nullable String path) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                map = this.data;
                string2 = "file_path";
                string = path;
                if (string == null) break block2;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                String string5 = string2;
                Map<String, Object> map2 = map;
                boolean bl3 = false;
                String string6 = EventLogConfiguration.INSTANCE.anonymize(path);
                map = map2;
                string2 = string5;
                string = string6;
                if (string != null) break block3;
            }
            string = "undefined";
        }
        map.put(string2, string);
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"anonymous_id:util#hash"})
    @NotNull
    public final FeatureUsageData addAnonymizedId(@NonNls @NotNull String id) {
        this.data.put("anonymous_id", EventLogConfiguration.INSTANCE.anonymize(id));
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @Nullable String value) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                map = this.data;
                string2 = key;
                string = value;
                if (string == null) break block2;
                String string3 = string;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                String string5 = string2;
                Map<String, Object> map2 = map;
                boolean bl3 = false;
                String string6 = EventLogConfiguration.INSTANCE.anonymize(value);
                map = map2;
                string2 = string5;
                string = string6;
                if (string != null) break block3;
            }
            string = "undefined";
        }
        map.put(string2, string);
        return this;
    }

    @FeatureUsageDataBuilder(additionalDataFields={"value::0"})
    @NotNull
    public final FeatureUsageData addValue(@NotNull Object value) {
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return this.addDataInternal("value", value);
        }
        return this.addData("value", value.toString());
    }

    @FeatureUsageDataBuilder(additionalDataFields={"enabled:enum#boolean"})
    @NotNull
    public final FeatureUsageData addEnabled(boolean enabled) {
        return this.addData("enabled", enabled);
    }

    @FeatureUsageDataBuilder(additionalDataFields={"count:regexp#integer"})
    @NotNull
    public final FeatureUsageData addCount(int count) {
        return this.addData("count", count);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, boolean value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, int value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, long value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, float value) {
        return this.addDataInternal(key, Float.valueOf(value));
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, double value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NonNls @NotNull String value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NotNull List<String> value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull Map<String, ? extends Object> value) {
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<? extends Map<String, ? extends Object>> value) {
        return this.addDataInternal(key, value);
    }

    private final FeatureUsageData addDataInternal(String key, Object value) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && platformDataKeys.contains(key)) {
            FeatureUsageDataKt.access$getLOG$p().warn("Collectors should not reuse platform keys: " + key);
            return this;
        }
        String escapedKey = StatisticsEventEscaper.escapeFieldName((String)key);
        if (Intrinsics.areEqual((Object)escapedKey, (Object)key) ^ true) {
            FeatureUsageDataKt.access$getLOG$p().warn("Key contains invalid symbols, they will be escaped: '" + key + "' -> '" + escapedKey + '\'');
        }
        this.data.put(escapedKey, value);
        return this;
    }

    @NotNull
    public final Map<String, Object> build() {
        if (this.data.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.data;
    }

    @NotNull
    public final FeatureUsageData addAll(@NotNull FeatureUsageData from) {
        this.data.putAll(from.data);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeatureUsageData merge(@NotNull FeatureUsageData next, @NonNls @NotNull String prefix) {
        Object object = next.build();
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            void newKey = StringsKt.startsWith$default((String)key, (String)"data_", (boolean)false, (int)2, null) ? prefix + (String)key : key;
            this.data.put((String)newKey, value);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeatureUsageData copy() {
        FeatureUsageData result = new FeatureUsageData();
        Object object = this.data;
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            result.data.put((String)key, value);
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.FeatureUsageData");
        }
        FeatureUsageData cfr_ignored_0 = (FeatureUsageData)object2;
        return !(Intrinsics.areEqual(this.data, ((FeatureUsageData)other).data) ^ true);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @NotNull
    public String toString() {
        return this.data.toString();
    }

    public FeatureUsageData() {
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        if (clientId != null && Intrinsics.areEqual((Object)clientId, (Object)ClientId.Companion.getDefaultLocalId()) ^ true) {
            this.addClientId(clientId.getValue());
        }
    }

    static {
        Companion = new Companion(null);
        platformDataKeys = CollectionsKt.listOf((Object[])new String[]{"plugin", "project", "os", "plugin_type", "lang", "current_file", "input_event", "place", "file_path", "anonymous_id", "client_id"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData$Companion;", "", "()V", "platformDataKeys", "", "", "getPlatformDataKeys", "()Ljava/util/List;", "intellij.platform.statistics"})
    public static final class Companion {
        @NotNull
        public final List<String> getPlatformDataKeys() {
            return platformDataKeys;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

