/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogAppConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.InternalDataCollectorDebugLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalApplicationInfo
implements EventLogApplicationInfo {
    private static final DataCollectorDebugLogger LOG = new InternalDataCollectorDebugLogger(Logger.getInstance(EventLogStatisticsService.class));
    private final boolean myIsTest;
    private final DataCollectorSystemEventLogger myEventLogger;
    private final EventLogAppConnectionSettings myConnectionSettings;

    public EventLogInternalApplicationInfo(final @NotNull String recorderId, boolean isTest) {
        this.myIsTest = isTest;
        this.myConnectionSettings = new EventLogAppConnectionSettings();
        this.myEventLogger = new DataCollectorSystemEventLogger(){

            public void logErrorEvent(@NotNull String eventId, @NotNull Throwable exception) {
                EventLogSystemLogger.logSystemError(recorderId, eventId, exception.getClass().getName(), -1L);
            }
        };
    }

    @NotNull
    public String getTemplateUrl() {
        return ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl();
    }

    @NotNull
    public String getProductCode() {
        return ApplicationInfo.getInstance().getBuild().getProductCode();
    }

    @NotNull
    public String getProductVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info.getMajorVersion() + "." + info.getMinorVersion();
    }

    @NotNull
    public EventLogConnectionSettings getConnectionSettings() {
        return this.myConnectionSettings;
    }

    public boolean isInternal() {
        return StatisticsUploadAssistant.isTestStatisticsEnabled();
    }

    public boolean isTest() {
        return this.myIsTest;
    }

    public boolean isEAP() {
        return ApplicationManager.getApplication().isEAP();
    }

    @NotNull
    public DataCollectorDebugLogger getLogger() {
        return LOG;
    }

    @NotNull
    public DataCollectorSystemEventLogger getEventLogger() {
        return this.myEventLogger;
    }
}

