/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.collectors.fus.ActionCustomPlaceAllowlist;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPlaceHolder {
    private static final Set<String> ourCustomPlaces = new HashSet<String>();

    private static void registerCustomPlaces(@Nullable String place) {
        if (StringUtil.isNotEmpty((String)place)) {
            if (!place.contains(";")) {
                ourCustomPlaces.add(place);
            } else {
                ourCustomPlaces.addAll(StringUtil.split((String)place, (String)";"));
            }
        }
    }

    public static boolean isCustomActionPlace(@NotNull String place) {
        return ourCustomPlaces.contains(place);
    }

    static {
        for (ActionCustomPlaceAllowlist extension : ActionCustomPlaceAllowlist.EP_NAME.getExtensionList()) {
            ActionPlaceHolder.registerCustomPlaces(extension.places);
        }
        ActionCustomPlaceAllowlist.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointAndAreaListener<ActionCustomPlaceAllowlist>(){

            public void extensionAdded(@NotNull ActionCustomPlaceAllowlist extension, @NotNull PluginDescriptor pluginDescriptor) {
                ActionPlaceHolder.registerCustomPlaces(extension.places);
            }
        }, null);
    }
}

