/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerConnection;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerListener;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getProject", "()Lcom/intellij/openapi/project/Project;", "gradleConfiguration", "", "configurationName", "", "registerDebuggerConnection", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDebuggerListener
implements DebuggerListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final Project project;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(CoroutineDebuggerListener.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @Nullable
    public DebuggerConnection registerDebuggerConnection(@NotNull RunConfigurationBase<?> configuration, @Nullable JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        boolean isExternalSystemRunConfiguration = configuration instanceof ExternalSystemRunConfiguration;
        ConfigurationType configurationType = configuration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
        String string = configurationType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.type.id");
        boolean isGradleConfiguration = this.gradleConfiguration(string);
        boolean disableCoroutineAgent = KotlinDebuggerSettings.Companion.getInstance().getDebugDisableCoroutineAgent();
        if (!disableCoroutineAgent && runnerSettings instanceof DebuggingRunnerData) {
            boolean modifyArgs = !isExternalSystemRunConfiguration || !isGradleConfiguration;
            return new DebuggerConnection(this.project, configuration, params, modifyArgs, false, 16, null);
        }
        return null;
    }

    private final boolean gradleConfiguration(String configurationName) {
        return Intrinsics.areEqual((Object)"GradleRunConfiguration", (Object)configurationName) || Intrinsics.areEqual((Object)"KotlinGradleRunConfiguration", (Object)configurationName);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public CoroutineDebuggerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.log$delegate = ProvidersKt.getLogger();
    }
}

