/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveProhibitedPropertyFix
implements LocalQuickFix {
    private final JsonValidationError.ProhibitedPropertyIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public RemoveProhibitedPropertyFix(JsonValidationError.ProhibitedPropertyIssueData data, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JsonBundle.message("remove.prohibited.property", new Object[0]);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return this.getFamilyName() + " '" + this.myData.propertyName + "'";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        assert (this.myData.propertyName.equals(this.myQuickFixAdapter.getPropertyName(element)));
        PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        element.delete();
        this.myQuickFixAdapter.removeIfComma(forward);
    }
}

