/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.adapters;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonArrayAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonGenericValueAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonObjectAdapter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final JsonProperty myProperty;

    public JsonJsonPropertyAdapter(@NotNull JsonProperty property) {
        this.myProperty = property;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myProperty.getName();
    }

    @Override
    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        return this.myProperty.getValue() == null ? ContainerUtil.emptyList() : Collections.singletonList(JsonJsonPropertyAdapter.createAdapterByType(this.myProperty.getValue()));
    }

    @Override
    @Nullable
    public JsonValueAdapter getNameValueAdapter() {
        return JsonJsonPropertyAdapter.createAdapterByType(this.myProperty.getNameElement());
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        return this.myProperty;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        return this.myProperty.getParent() instanceof JsonObject ? new JsonJsonObjectAdapter((JsonObject)this.myProperty.getParent()) : null;
    }

    @NotNull
    public static JsonValueAdapter createAdapterByType(@NotNull JsonValue value) {
        if (value instanceof JsonObject) {
            return new JsonJsonObjectAdapter((JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return new JsonJsonArrayAdapter((JsonArray)value);
        }
        return new JsonJsonGenericValueAdapter(value);
    }
}

