/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MatchResult {
    public final List<JsonSchemaObject> mySchemas;
    public final List<Collection<? extends JsonSchemaObject>> myExcludingSchemas;

    private MatchResult(@NotNull List<JsonSchemaObject> schemas, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        this.mySchemas = Collections.unmodifiableList(schemas);
        this.myExcludingSchemas = Collections.unmodifiableList(excludingSchemas);
    }

    public static MatchResult create(@NotNull JsonSchemaTreeNode root) {
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>();
        Int2ObjectOpenHashMap oneOfGroups = new Int2ObjectOpenHashMap();
        MatchResult.iterateTree(root, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            if (node.isAny()) {
                return true;
            }
            int groupNumber = node.getExcludingGroupNumber();
            if (groupNumber < 0) {
                schemas.add(node.getSchema());
            } else {
                ((List)oneOfGroups.computeIfAbsent(groupNumber, __ -> new ArrayList())).add(node.getSchema());
            }
            return true;
        }));
        List<Collection<? extends JsonSchemaObject>> result = oneOfGroups.isEmpty() ? Collections.emptyList() : new ArrayList(oneOfGroups.values());
        return new MatchResult(schemas, result);
    }

    public static void iterateTree(@NotNull JsonSchemaTreeNode root, @NotNull Processor<? super JsonSchemaTreeNode> processor) {
        ArrayDeque<JsonSchemaTreeNode> queue = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue.isEmpty()) {
            JsonSchemaTreeNode node = queue.removeFirst();
            if (node.getChildren().isEmpty()) {
                if (node.isNothing() || !SchemaResolveState.normal.equals((Object)node.getResolveState()) || processor.process((Object)node)) continue;
                break;
            }
            queue.addAll(node.getChildren());
        }
    }
}

