/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaInjectorBase;
import org.intellij.lang.regexp.ecmascript.EcmaScriptRegexpLanguage;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaRegexInjector
extends JsonSchemaInjectorBase {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        JsonOriginalPsiWalker walker;
        if (!(context instanceof JsonStringLiteral)) {
            return;
        }
        if (!JsonSchemaService.isSchemaFile(context.getContainingFile())) {
            return;
        }
        ThreeState isName = (walker = JsonOriginalPsiWalker.INSTANCE).isName(context);
        JsonPointerPosition position = walker.findPosition(context, isName == ThreeState.NO);
        if (position == null || position.isEmpty()) {
            return;
        }
        if (isName == ThreeState.YES) {
            if ("patternProperties".equals(position.getLastName())) {
                if (JsonSchemaRegexInjector.isNestedInPropertiesList(position)) {
                    return;
                }
                JsonSchemaRegexInjector.injectForHost(registrar, (JsonStringLiteral)context, (Language)EcmaScriptRegexpLanguage.INSTANCE);
            }
        } else if (isName == ThreeState.NO && "pattern".equals(position.getLastName())) {
            if (JsonSchemaRegexInjector.isNestedInPropertiesList(position)) {
                return;
            }
            JsonSchemaRegexInjector.injectForHost(registrar, (JsonStringLiteral)context, (Language)EcmaScriptRegexpLanguage.INSTANCE);
        }
    }

    private static boolean isNestedInPropertiesList(JsonPointerPosition position) {
        JsonPointerPosition skipped = position.trimTail(1);
        return skipped != null && "properties".equals(skipped.getLastName());
    }
}

