/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaComplianceChecker {
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");
    @NotNull
    private final JsonSchemaObject myRootSchema;
    @NotNull
    private final ProblemsHolder myHolder;
    @NotNull
    private final JsonLikePsiWalker myWalker;
    private final LocalInspectionToolSession mySession;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    @Nullable
    private final String myMessagePrefix;

    public JsonSchemaComplianceChecker(@NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull JsonLikePsiWalker walker, @NotNull LocalInspectionToolSession session, @NotNull JsonComplianceCheckerOptions options) {
        this(rootSchema, holder, walker, session, options, null);
    }

    public JsonSchemaComplianceChecker(@NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull JsonLikePsiWalker walker, @NotNull LocalInspectionToolSession session, @NotNull JsonComplianceCheckerOptions options, @Nullable String messagePrefix) {
        this.myRootSchema = rootSchema;
        this.myHolder = holder;
        this.myWalker = walker;
        this.mySession = session;
        this.myOptions = options;
        this.myMessagePrefix = messagePrefix;
    }

    public void annotate(@NotNull PsiElement element) {
        Project project = element.getProject();
        JsonPropertyAdapter firstProp = this.myWalker.getParentPropertyAdapter(element);
        if (firstProp != null) {
            JsonPointerPosition position = this.myWalker.findPosition(firstProp.getDelegate(), true);
            if (position == null || position.isEmpty()) {
                return;
            }
            MatchResult result = new JsonSchemaResolver(project, this.myRootSchema, position).detailedResolve();
            for (JsonValueAdapter value : firstProp.getValues()) {
                this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(project, value, result, this.myOptions));
            }
        }
        this.checkRoot(element, firstProp);
    }

    private void checkRoot(@NotNull PsiElement element, @Nullable JsonPropertyAdapter firstProp) {
        JsonValueAdapter rootToCheck;
        if (firstProp == null) {
            rootToCheck = JsonSchemaComplianceChecker.findTopLevelElement(this.myWalker, element);
        } else {
            rootToCheck = firstProp.getParentObject();
            if (rootToCheck == null || !this.myWalker.isTopJsonElement(rootToCheck.getDelegate().getParent())) {
                return;
            }
        }
        if (rootToCheck != null) {
            Project project = element.getProject();
            MatchResult matchResult = new JsonSchemaResolver(project, this.myRootSchema).detailedResolve();
            this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(project, rootToCheck, matchResult, this.myOptions));
        }
    }

    private void createWarnings(@Nullable JsonSchemaAnnotatorChecker checker) {
        if (checker == null || checker.isCorrect()) {
            return;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<ArrayList> entries = new ArrayList<ArrayList>();
        for (Map.Entry<PsiElement, JsonValidationError> entry : checker.getErrors().entrySet()) {
            TextRange range = entry.getKey().getTextRange();
            boolean processed = false;
            for (int i = 0; i < ranges.size(); ++i) {
                TextRange currRange = (TextRange)ranges.get(i);
                if (!currRange.intersects(range)) continue;
                ranges.set(i, new TextRange(Math.min(currRange.getStartOffset(), range.getStartOffset()), Math.max(currRange.getEndOffset(), range.getEndOffset())));
                ((List)entries.get(i)).add(entry);
                processed = true;
                break;
            }
            if (processed) continue;
            ranges.add(range);
            entries.add(ContainerUtil.newArrayList((Object[])new Map.Entry[]{entry}));
        }
        for (List list : entries) {
            int min = list.stream().map(v -> ((JsonValidationError)v.getValue()).getPriority().ordinal()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
            for (Map.Entry entry : list) {
                JsonValidationError validationError = (JsonValidationError)entry.getValue();
                PsiElement psiElement = (PsiElement)entry.getKey();
                if (validationError.getPriority().ordinal() > min) continue;
                TextRange range = this.myWalker.adjustErrorHighlightingRange(psiElement);
                range = range.shiftLeft(psiElement.getTextRange().getStartOffset());
                this.registerError(psiElement, range, validationError);
            }
        }
    }

    private void registerError(@NotNull PsiElement psiElement, @NotNull TextRange range, @NotNull JsonValidationError validationError) {
        PsiElement element;
        if (this.checkIfAlreadyProcessed(psiElement)) {
            return;
        }
        String value = validationError.getMessage();
        if (this.myMessagePrefix != null) {
            value = this.myMessagePrefix + value;
        }
        LocalQuickFix[] fix = validationError.createFixes(this.myWalker.getSyntaxAdapter(this.myHolder.getProject()));
        Object object = element = range.isEmpty() ? psiElement.getContainingFile() : psiElement;
        if (fix.length == 0) {
            this.myHolder.registerProblem(element, range, value, new LocalQuickFix[0]);
        } else {
            this.myHolder.registerProblem(element, range, value, fix);
        }
    }

    private static JsonValueAdapter findTopLevelElement(@NotNull JsonLikePsiWalker walker, @NotNull PsiElement element) {
        Ref ref = new Ref();
        PsiTreeUtil.findFirstParent((PsiElement)element, el -> {
            boolean isTop = walker.isTopJsonElement((PsiElement)el);
            if (!isTop) {
                ref.set(el);
            }
            return isTop;
        });
        return ref.isNull() ? (walker.acceptsEmptyRoot() ? walker.createValueAdapter(element) : null) : walker.createValueAdapter((PsiElement)ref.get());
    }

    private boolean checkIfAlreadyProcessed(@NotNull PsiElement property) {
        HashSet<PsiElement> data = (HashSet<PsiElement>)this.mySession.getUserData(ANNOTATED_PROPERTIES);
        if (data == null) {
            data = new HashSet<PsiElement>();
            this.mySession.putUserData(ANNOTATED_PROPERTIES, data);
        }
        if (data.contains(property)) {
            return true;
        }
        data.add(property);
        return false;
    }
}

