/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonOriginalPsiWalker
implements JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker INSTANCE = new JsonOriginalPsiWalker();

    public boolean handles(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        return element instanceof JsonFile && JsonDialectUtil.isStandardJson(element) || parent != null && (element instanceof JsonElement || element instanceof LeafPsiElement && parent instanceof JsonElement) && JsonDialectUtil.isStandardJson(CompletionUtil.getOriginalOrSelf((PsiElement)parent));
    }

    @Override
    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JsonObject) {
            return ThreeState.YES;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)element, (boolean)false) ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.NO;
    }

    @Override
    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element instanceof JsonStringLiteral || element instanceof JsonReferenceExpression) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof JsonProperty) || ((JsonProperty)parent).getNameElement() != element) {
                return false;
            }
            element = parent;
        }
        return element instanceof JsonProperty && ((JsonProperty)element).getValue() != null;
    }

    @Override
    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue) && !(current instanceof JsonProperty)) continue;
            return current;
        }
        return null;
    }

    @Override
    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array = (JsonArray)current;
                List<JsonValue> list = array.getValueList();
                int idx = -1;
                for (int i = 0; i < list.size(); ++i) {
                    JsonValue value = list.get(i);
                    if (!value.equals(position)) continue;
                    idx = i;
                    break;
                }
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof JsonProperty) {
                propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        return pos;
    }

    @Override
    public boolean requiresNameQuotes() {
        return true;
    }

    @Override
    public boolean allowsSingleQuotes() {
        return false;
    }

    @Override
    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        PsiElement current;
        PsiElement psiElement = current = element instanceof JsonProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        while (current != null && current.getNode().getElementType() != JsonElementTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        if (object != null) {
            for (JsonProperty property : object.getPropertyList()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, JsonObject.class);
        if (object != null) {
            return object.getPropertyList().stream().filter(p -> !this.requiresNameQuotes() || p.getNameElement() instanceof JsonStringLiteral).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if (property == null) {
            return null;
        }
        return new JsonJsonPropertyAdapter(property);
    }

    @Override
    public boolean isTopJsonElement(@NotNull PsiElement element) {
        return element instanceof PsiFile;
    }

    @Override
    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        return element instanceof JsonValue ? JsonJsonPropertyAdapter.createAdapterByType((JsonValue)element) : null;
    }

    @Override
    public JsonLikeSyntaxAdapter getSyntaxAdapter(final Project project) {
        return new JsonLikeSyntaxAdapter(){
            private final JsonElementGenerator myGenerator;
            {
                this.myGenerator = new JsonElementGenerator(project);
            }

            @Override
            @Nullable
            public PsiElement getPropertyValue(PsiElement property) {
                assert (property instanceof JsonProperty);
                return ((JsonProperty)property).getValue();
            }

            @Override
            @NotNull
            public String getPropertyName(PsiElement property) {
                assert (property instanceof JsonProperty);
                return ((JsonProperty)property).getName();
            }

            @Override
            @NotNull
            public PsiElement createProperty(@NotNull String name, @NotNull String value, PsiElement element) {
                return this.myGenerator.createProperty(name, value);
            }

            @Override
            public boolean ensureComma(PsiElement self, PsiElement newElement) {
                if (newElement instanceof JsonProperty && self instanceof JsonProperty) {
                    self.getParent().addAfter(this.myGenerator.createComma(), self);
                    return true;
                }
                return false;
            }

            @Override
            public void removeIfComma(PsiElement forward) {
                if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == JsonElementTypes.COMMA) {
                    forward.delete();
                }
            }

            @Override
            public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
                return true;
            }

            @Override
            @NotNull
            public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
                return type == null ? "" : type.getDefaultValue();
            }

            @Override
            public PsiElement adjustNewProperty(PsiElement element) {
                return element;
            }

            @Override
            public PsiElement adjustPropertyAnchor(LeafPsiElement element) {
                throw new IncorrectOperationException("Shouldn't use leafs for insertion in pure JSON!");
            }
        };
    }

    @Override
    @Nullable
    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class), (Class[])new Class[]{JsonObject.class, JsonArray.class});
    }

    @Override
    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        return file instanceof JsonFile ? ContainerUtil.createMaybeSingletonList((Object)((JsonFile)file).getTopLevelValue()) : ContainerUtil.emptyList();
    }

    @Override
    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof JsonProperty ? ((JsonProperty)property).getNameElement() : null;
    }
}

