/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="SchemaInfo")
public class UserDefinedJsonSchemaConfiguration {
    private static final Comparator<Item> ITEM_COMPARATOR = (o1, o2) -> {
        if (o1.isPattern() != o2.isPattern()) {
            return o1.isPattern() ? -1 : 1;
        }
        if (o1.isDirectory() != o2.isDirectory()) {
            return o1.isDirectory() ? -1 : 1;
        }
        return o1.path.compareToIgnoreCase(o2.path);
    };
    public String name;
    public String relativePathToSchema;
    public JsonSchemaVersion schemaVersion = JsonSchemaVersion.SCHEMA_4;
    public boolean applicationDefined;
    public List<Item> patterns = new SmartList();
    @Transient
    private final AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>> myCalculatedPatterns = new AtomicClearableLazyValue<List<PairProcessor<Project, VirtualFile>>>(){

        @NotNull
        protected List<PairProcessor<Project, VirtualFile>> compute() {
            return UserDefinedJsonSchemaConfiguration.this.recalculatePatterns();
        }
    };

    public UserDefinedJsonSchemaConfiguration() {
    }

    public UserDefinedJsonSchemaConfiguration(@NotNull String name, JsonSchemaVersion schemaVersion, @NotNull String relativePathToSchema, boolean applicationDefined, @Nullable List<Item> patterns) {
        this.name = name;
        this.relativePathToSchema = relativePathToSchema;
        this.schemaVersion = schemaVersion;
        this.applicationDefined = applicationDefined;
        this.setPatterns(patterns);
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getRelativePathToSchema() {
        return Item.normalizePath(this.relativePathToSchema);
    }

    public JsonSchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(JsonSchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setRelativePathToSchema(String relativePathToSchema) {
        this.relativePathToSchema = Item.neutralizePath(relativePathToSchema);
    }

    public boolean isApplicationDefined() {
        return this.applicationDefined;
    }

    public void setApplicationDefined(boolean applicationDefined) {
        this.applicationDefined = applicationDefined;
    }

    public List<Item> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(@Nullable List<Item> patterns) {
        this.patterns.clear();
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        this.patterns.sort(ITEM_COMPARATOR);
        this.myCalculatedPatterns.drop();
    }

    public void refreshPatterns() {
        this.myCalculatedPatterns.drop();
    }

    @NotNull
    public List<PairProcessor<Project, VirtualFile>> getCalculatedPatterns() {
        return (List)this.myCalculatedPatterns.getValue();
    }

    private List<PairProcessor<Project, VirtualFile>> recalculatePatterns() {
        SmartList result = new SmartList();
        for (Item patternText : this.patterns) {
            switch (patternText.mappingKind) {
                case File: {
                    result.add((project, vfile) -> vfile.equals(UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText)) || vfile.getUrl().equals(Item.neutralizePath(patternText.getPath())));
                    break;
                }
                case Pattern: {
                    String pathText = patternText.getPath().replace(File.separatorChar, '/').replace('\\', '/');
                    Pattern pattern = pathText.isEmpty() ? PatternUtil.NOTHING : (pathText.indexOf(47) >= 0 ? PatternUtil.compileSafe((String)(".*/" + PatternUtil.convertToRegex((String)pathText)), (Pattern)PatternUtil.NOTHING) : PatternUtil.fromMask((String)pathText));
                    result.add((project, file) -> JsonSchemaObject.matchPattern(pattern, pathText.indexOf(47) >= 0 ? file.getPath() : file.getName()));
                    break;
                }
                case Directory: {
                    result.add((project, vfile) -> {
                        VirtualFile relativeFile = UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText);
                        if (relativeFile == null || !VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)vfile, (boolean)true)) {
                            return false;
                        }
                        JsonSchemaService service = JsonSchemaService.Impl.get(project);
                        return service.isApplicableToFile((VirtualFile)vfile);
                    });
                }
            }
        }
        return result;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@NotNull Project project, @NotNull Item pattern) {
        if (project.getBasePath() == null) {
            return null;
        }
        String path = FileUtilRt.toSystemIndependentName((String)StringUtil.notNullize((String)pattern.path));
        List<String> parts = UserDefinedJsonSchemaConfiguration.pathToPartsList(path);
        if (parts.isEmpty()) {
            return project.getBaseDir();
        }
        return VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])ArrayUtilRt.toStringArray(parts));
    }

    @NotNull
    private static List<String> pathToPartsList(@NotNull String path) {
        return ContainerUtil.filter((Collection)StringUtil.split((String)path, (String)"/"), s -> !".".equals(s));
    }

    private static String @NotNull [] pathToParts(@NotNull String path) {
        return ArrayUtilRt.toStringArray(UserDefinedJsonSchemaConfiguration.pathToPartsList(path));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration info = (UserDefinedJsonSchemaConfiguration)o;
        if (this.applicationDefined != info.applicationDefined) {
            return false;
        }
        if (this.schemaVersion != info.schemaVersion) {
            return false;
        }
        if (!Objects.equals(this.name, info.name)) {
            return false;
        }
        if (!Objects.equals(this.relativePathToSchema, info.relativePathToSchema)) {
            return false;
        }
        return Objects.equals(this.patterns, info.patterns);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.relativePathToSchema != null ? this.relativePathToSchema.hashCode() : 0);
        result = 31 * result + (this.applicationDefined ? 1 : 0);
        result = 31 * result + (this.patterns != null ? this.patterns.hashCode() : 0);
        result = 31 * result + this.schemaVersion.hashCode();
        return result;
    }

    public static class Item {
        public String path;
        public JsonMappingKind mappingKind = JsonMappingKind.File;

        public Item() {
        }

        public Item(String path, JsonMappingKind mappingKind) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = mappingKind;
        }

        public Item(String path, boolean isPattern, boolean isDirectory) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = isPattern ? JsonMappingKind.Pattern : (isDirectory ? JsonMappingKind.Directory : JsonMappingKind.File);
        }

        @NotNull
        private static String normalizePath(@NotNull String path) {
            if (Item.preserveSlashes(path)) {
                return path;
            }
            return StringUtil.trimEnd((String)FileUtilRt.toSystemDependentName((String)path), (char)File.separatorChar);
        }

        private static boolean preserveSlashes(@NotNull String path) {
            return StringUtil.startsWith((CharSequence)path, (CharSequence)"http:") || StringUtil.startsWith((CharSequence)path, (CharSequence)"https:") || JsonFileResolver.isTempOrMockUrl(path);
        }

        @NotNull
        public static String neutralizePath(@NotNull String path) {
            if (Item.preserveSlashes(path)) {
                return path;
            }
            return StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)path), (char)'/');
        }

        public String getPath() {
            return Item.normalizePath(this.path);
        }

        public void setPath(String path) {
            this.path = Item.neutralizePath(path);
        }

        public String getError() {
            switch (this.mappingKind) {
                case File: {
                    return !StringUtil.isEmpty((String)this.path) ? null : JsonBundle.message("schema.configuration.error.empty.file.path", new Object[0]);
                }
                case Pattern: {
                    return !StringUtil.isEmpty((String)this.path) ? null : JsonBundle.message("schema.configuration.error.empty.pattern", new Object[0]);
                }
                case Directory: {
                    return null;
                }
            }
            return JsonBundle.message("schema.configuration.error.unknown.mapping", new Object[0]);
        }

        public boolean isPattern() {
            return this.mappingKind == JsonMappingKind.Pattern;
        }

        public void setPattern(boolean pattern) {
            this.mappingKind = pattern ? JsonMappingKind.Pattern : JsonMappingKind.File;
        }

        public boolean isDirectory() {
            return this.mappingKind == JsonMappingKind.Directory;
        }

        public void setDirectory(boolean directory) {
            this.mappingKind = directory ? JsonMappingKind.Directory : JsonMappingKind.File;
        }

        public String getPresentation() {
            if (this.mappingKind == JsonMappingKind.Directory && StringUtil.isEmpty((String)this.path)) {
                return JsonBundle.message("schema.configuration.project.directory", this.mappingKind.getPrefix());
            }
            return this.mappingKind.getPrefix() + this.getPath();
        }

        public String[] getPathParts() {
            return UserDefinedJsonSchemaConfiguration.pathToParts(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.mappingKind != item.mappingKind) {
                return false;
            }
            return Objects.equals(this.path, item.path);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.path);
            result = 31 * result + Objects.hashCode((Object)this.mappingKind);
            return result;
        }
    }
}

