/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralManipulator
extends AbstractElementManipulator<JsonStringLiteral> {
    public JsonStringLiteral handleContentChange(@NotNull JsonStringLiteral element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        assert (new TextRange(0, element.getTextLength()).contains(range));
        String originalContent = element.getText();
        TextRange withoutQuotes = this.getRangeInElement(element);
        JsonElementGenerator generator = new JsonElementGenerator(element.getProject());
        String replacement = originalContent.substring(withoutQuotes.getStartOffset(), range.getStartOffset()) + newContent + originalContent.substring(range.getEndOffset(), withoutQuotes.getEndOffset());
        return (JsonStringLiteral)element.replace(generator.createStringLiteral(replacement));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JsonStringLiteral element) {
        String content = element.getText();
        int startOffset = content.startsWith("'") || content.startsWith("\"") ? 1 : 0;
        int endOffset = content.length() > 1 && (content.endsWith("'") || content.endsWith("\"")) ? -1 : 0;
        return new TextRange(startOffset, content.length() + endOffset);
    }
}

