/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSortPropertiesIntention
implements IntentionAction,
LowPriorityAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return JsonBundle.message("json.intention.sort.properties", new Object[0]);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JsonBundle.message("json.intention.sort.properties", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement parent = JsonSortPropertiesIntention.findParentObject(editor, file);
        return parent instanceof JsonObject && !JsonSortPropertiesIntention.isSorted((JsonObject)parent);
    }

    @Nullable
    private static PsiElement findParentObject(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        return property == null ? null : property.getParent();
    }

    private static boolean isSorted(@NotNull JsonObject parent) {
        List<JsonProperty> list = parent.getPropertyList();
        if (list.size() <= 1) {
            return true;
        }
        List names = ContainerUtil.map(list, p -> p.getName());
        return ContainerUtil.equalsIdentity((List)ContainerUtil.sorted((Collection)names), (List)names);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JsonBundle.message("file.is.readonly", new Object[0]), (String)JsonBundle.message("cannot.sort.properties", new Object[0]), null);
            return;
        }
        PsiElement parentObject = JsonSortPropertiesIntention.findParentObject(editor, file);
        assert (parentObject instanceof JsonObject);
        JsonSortPropertiesIntention.cycleSortProperties(((JsonObject)parentObject).getPropertyList());
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)parentObject);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement element = pointer.getElement();
        if (element == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(element.getContainingFile(), Collections.singleton(element.getTextRange()));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void cycleSortProperties(@NotNull List<JsonProperty> properties) {
        int size = properties.size();
        for (int cycleStart = 0; cycleStart < size; ++cycleStart) {
            JsonProperty item = properties.get(cycleStart);
            int pos = JsonSortPropertiesIntention.advance(properties, size, cycleStart, item);
            if (pos == -1) continue;
            if (pos != cycleStart) {
                JsonSortPropertiesIntention.exchange(properties, pos, cycleStart);
            }
            while (pos != cycleStart && (pos = JsonSortPropertiesIntention.advance(properties, size, cycleStart, properties.get(cycleStart))) != -1) {
                if (pos == cycleStart) continue;
                JsonSortPropertiesIntention.exchange(properties, pos, cycleStart);
            }
        }
    }

    private static int advance(@NotNull List<JsonProperty> properties, int size, int cycleStart, JsonProperty item) {
        int pos = cycleStart;
        String itemName = item.getName();
        for (int i = cycleStart + 1; i < size; ++i) {
            if (properties.get(i).getName().compareTo(itemName) >= 0) continue;
            ++pos;
        }
        if (pos == cycleStart) {
            return -1;
        }
        while (Objects.equals(itemName, properties.get(pos).getName())) {
            ++pos;
        }
        return pos;
    }

    private static void exchange(@NotNull List<JsonProperty> properties, int pos, int item) {
        JsonProperty propertyAtPos = properties.get(pos);
        JsonProperty itemProperty = properties.get(item);
        properties.set(pos, (JsonProperty)propertyAtPos.getParent().addBefore((PsiElement)itemProperty, (PsiElement)propertyAtPos));
        properties.set(item, (JsonProperty)itemProperty.getParent().addBefore((PsiElement)propertyAtPos, (PsiElement)itemProperty));
        propertyAtPos.delete();
        itemProperty.delete();
    }
}

