/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_BRACES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"});
            consumer.renameStandardOption("SPACE_WITHIN_BRACES", "Braces");
            consumer.showCustomOption(JsonCodeStyleSettings.class, "SPACE_BEFORE_COLON", "Before ':'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JsonCodeStyleSettings.class, "SPACE_AFTER_COLON", "After ':'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES"});
            consumer.showCustomOption(JsonCodeStyleSettings.class, "KEEP_TRAILING_COMMA", "Trailing comma", CodeStyleSettingsCustomizable.WRAPPING_KEEP, new Object[0]);
            consumer.showCustomOption(JsonCodeStyleSettings.class, "ARRAY_WRAPPING", "Arrays", null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JsonCodeStyleSettings.class, "OBJECT_WRAPPING", "Objects", null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JsonCodeStyleSettings.class, "PROPERTY_ALIGNMENT", JsonBundle.message("formatter.align.properties.caption", new Object[0]), "Objects", new Object[]{Holder.ALIGN_OPTIONS, Holder.ALIGN_VALUES});
        }
    }

    @NotNull
    public Language getLanguage() {
        return JsonLanguage.INSTANCE;
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return "{\n    \"json literals are\": {\n        \"strings\": [\"foo\", \"bar\", \"\\u0062\\u0061\\u0072\"],\n        \"numbers\": [42, 6.62606975e-34],\n        \"boolean values\": [true, false,],\n        \"objects\": {\"null\": null,\"another\": null,}\n    }\n}";
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        indentOptions.INDENT_SIZE = 2;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 0;
    }

    private static class Holder {
        private static final String[] ALIGN_OPTIONS = (String[])Arrays.stream(JsonCodeStyleSettings.PropertyAlignment.values()).map(alignment -> alignment.getDescription()).toArray(String[]::new);
        private static final int[] ALIGN_VALUES = ArrayUtil.toIntArray((Collection)ContainerUtil.map((Object[])JsonCodeStyleSettings.PropertyAlignment.values(), alignment -> alignment.getId()));
        private static final String SAMPLE = "{\n    \"json literals are\": {\n        \"strings\": [\"foo\", \"bar\", \"\\u0062\\u0061\\u0072\"],\n        \"numbers\": [42, 6.62606975e-34],\n        \"boolean values\": [true, false,],\n        \"objects\": {\"null\": null,\"another\": null,}\n    }\n}";

        private Holder() {
        }
    }
}

