/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> cls) {
        if (expression == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression.getClass())) {
            return (T)expression;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        JsonProperty property = object.findProperty(name);
        if (property == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property.getValue(), clazz));
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static int getArrayIndexOfItem(@NotNull PsiElement e) {
        PsiElement parent = e.getParent();
        if (!(parent instanceof JsonArray)) {
            return -1;
        }
        List<JsonValue> elements = ((JsonArray)parent).getValueList();
        for (int i = 0; i < elements.size(); ++i) {
            if (e != elements.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JsonObject getTopLevelObject(@Nullable JsonFile jsonFile) {
        return jsonFile != null ? (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class) : null;
    }

    public static boolean isJsonFile(@NotNull VirtualFile file, @Nullable Project project) {
        FileType type = file.getFileType();
        if (type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof JsonLanguage) {
            return true;
        }
        if (project == null || !ScratchUtil.isScratch((VirtualFile)file)) {
            return false;
        }
        RootType rootType = ScratchFileService.findRootType((VirtualFile)file);
        return rootType != null && rootType.substituteLanguage(project, file) instanceof JsonLanguage;
    }
}

