/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.usages.UsageTarget;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.usages.OCUsageTargetProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class OCHighlightUsagesCase
extends OCCodeInsightTestCase {
    private static final String REF = "s";

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
    }

    protected void assertUsagesCpp(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.CPP, false, true);
    }

    protected void noUsagesCpp(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.CPP, true, true);
    }

    protected void assertUsagesC(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.C, false, true);
    }

    protected void assertUsages(@NotNull String text, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations) {
        this.assertUsages(text, languageKind, checkNothingToFindAtCursor, withDeclarations, false);
    }

    protected void assertUsages(@NotNull String text, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations, boolean withRefMerge) {
        OCFile file2 = this.configureByText(text.replaceAll("<s>", "").replace("</s>", ""), languageKind);
        UsageTarget[] targets = new OCUsageTargetProvider().getTargets(this.getEditor(), (PsiFile)file2);
        OCHighlightUsagesCase.assertNotNull((Object)targets);
        if (0 == targets.length && checkNothingToFindAtCursor) {
            return;
        }
        OCHighlightUsagesCase.assertFalse((String)"Nothing to find at cursor", (0 == targets.length ? 1 : 0) != 0);
        OCHighlightUsagesCase.assertFalse((String)"Too many named elements at cursor", (1 < targets.length ? 1 : 0) != 0);
        PsiElement2UsageTargetAdapter psiTarget = (PsiElement2UsageTargetAdapter)OCHighlightUsagesCase.assertInstanceOf((Object)targets[0], PsiElement2UsageTargetAdapter.class);
        PsiElement targetElement = psiTarget.getElement();
        OCHighlightUsagesCase.assertNotNull((Object)targetElement);
        Couple usages = IdentifierHighlighterPass.getHighlightUsages((PsiElement)targetElement, (PsiElement)file2, (boolean)withDeclarations);
        if (withRefMerge) {
            usages = Couple.of(new HashSet((Collection)usages.getFirst()), new HashSet((Collection)usages.getSecond()));
        }
        ArrayList allUsages = new ArrayList();
        allUsages.addAll((Collection)usages.getFirst());
        allUsages.addAll((Collection)usages.getSecond());
        OCHighlightUsagesCase.assertEquals((String)text.replace("<caret>", ""), (String)CodeInsightTestFixtureImpl.getTagsFromSegments((String)file2.getText(), allUsages, (String)REF, null));
    }
}

