/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class OCMockProjectReader {
    public static final String EXTENSION = "yaml";

    public static void read(@NotNull File projectFile, @NotNull OCMockWorkspace mockWorkspace) {
        OCWorkspace.ModifiableModel model = mockWorkspace.getDelegate().getModifiableModel(mockWorkspace.getClientKey(), true);
        try {
            OCMockProjectReader.doRead(projectFile, mockWorkspace, model);
            model.preCommit();
            WriteAction.run(() -> ((OCWorkspace.ModifiableModel)model).commit());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            model.dispose();
        }
    }

    private static void doRead(@NotNull File projectFile, @NotNull OCMockWorkspace mockWorkspace, @NotNull OCWorkspace.ModifiableModel workspaceModel) throws IOException {
        Yaml yaml = new Yaml();
        Object object = yaml.load(FileUtil.loadFile((File)projectFile, (Charset)StandardCharsets.UTF_8));
        if (object == null) {
            return;
        }
        if (!(object instanceof Map)) {
            throw new RuntimeException("Unexpected project format " + object);
        }
        File baseDir = projectFile.getParentFile();
        LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(baseDir), false, true, null);
        VirtualFile virtualFileDir = LocalFileSystem.getInstance().findFileByIoFile(baseDir);
        if (virtualFileDir == null) {
            throw new RuntimeException("Basedir not found " + baseDir);
        }
        Map projectEntriesMap = (Map)object;
        Object projectAttribute = projectEntriesMap.get("project");
        if (projectAttribute instanceof Map && Boolean.FALSE.equals(((Map)projectAttribute).get("content_root_as_source_folder"))) {
            mockWorkspace.setContentRootAsSourceFolder(false);
        }
        OCMockProjectReader.readGeneratedSources(mockWorkspace, virtualFileDir, projectEntriesMap);
        Collection<Object> profiles = Collections.singletonList(null);
        Object profilesAttribute = projectEntriesMap.get("profiles");
        if (profilesAttribute instanceof List) {
            profiles = (Collection)profilesAttribute;
        }
        for (String string : profiles) {
            if (!projectEntriesMap.containsKey("configs")) {
                OCResolveConfiguration.ModifiableModel config = OCMockProjectReader.addConfiguration(workspaceModel, "default", string);
                OCMockWorkspace.CompilerSettingsData compilerSettings = OCMockProjectReader.readConfigOptions(config, virtualFileDir, projectEntriesMap);
                OCMockProjectReader.readFiles(mockWorkspace, config, compilerSettings, virtualFileDir, projectEntriesMap);
                return;
            }
            Object configs = projectEntriesMap.get("configs");
            if (configs == null) {
                return;
            }
            for (Object eachConfig : (List)configs) {
                boolean inlinedFiles;
                Set entries = ((Map)eachConfig).entrySet();
                Iterator iterator = entries.iterator();
                Map.Entry header = iterator.next();
                String configId = (String)header.getKey();
                OCResolveConfiguration.ModifiableModel configModel = OCMockProjectReader.addConfiguration(workspaceModel, configId, string);
                LinkedHashMap configMap = new LinkedHashMap();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    configMap.put(next.getKey(), next.getValue());
                }
                OCMockWorkspace.CompilerSettingsData compilerSettings = OCMockProjectReader.readConfigOptions(configModel, virtualFileDir, configMap);
                boolean bl = inlinedFiles = header.getValue() != null;
                if (inlinedFiles) {
                    OCMockProjectReader.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, Collections.singletonMap("files", header.getValue()));
                }
                if (!OCMockProjectReader.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, configMap) || !inlinedFiles) continue;
                throw new RuntimeException("Config " + configModel.getUniqueId() + " has conflicting files sections");
            }
        }
    }

    @NotNull
    private static OCResolveConfiguration.ModifiableModel addConfiguration(@NotNull OCWorkspace.ModifiableModel workspaceModel, @NotNull String configName, @Nullable String profile) {
        String configId = profile == null ? configName : configName + " [" + profile + "]";
        return workspaceModel.addConfiguration(configId, configName, profile == null ? null : new OCVariant(profile));
    }

    @NotNull
    private static OCMockWorkspace.CompilerSettingsData readConfigOptions(@NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        OCCompilerSettings.ModifiableModel defaultSettingsModel = configModel.getDefaultCompilerSettings();
        OCMockProjectReader.readSearchPaths(defaultSettingsModel, baseDir, map);
        OCMockProjectReader.readPCHOptions(defaultSettingsModel, baseDir, map);
        String compilerKind = (String)map.get("compiler");
        if (compilerKind != null) {
            boolean compiledFound = false;
            for (OCCompilerKind oCCompilerKind : OCCompilerKind.values()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)oCCompilerKind.getDisplayName(), (CharSequence)compilerKind)) continue;
                defaultSettingsModel.setCompiler(oCCompilerKind, null, null);
                compiledFound = true;
                break;
            }
            if (!compiledFound) {
                throw new RuntimeException("Unknown compiler: " + compilerKind);
            }
        }
        OCMockWorkspace.CompilerSettingsData settings = OCMockProjectReader.getCompilerSettings(baseDir, map);
        for (OCCompilerKind oCCompilerKind : CLanguageKind.values()) {
            OCMockWorkspace.applyDefinesAndFeatures((OCLanguageKind)oCCompilerKind, configModel.getLanguageCompilerSettings((OCLanguageKind)oCCompilerKind), settings);
        }
        return settings;
    }

    @NotNull
    private static OCMockWorkspace.CompilerSettingsData getCompilerSettings(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        return new OCMockWorkspace.CompilerSettingsData(OCMockProjectReader.getDefines(map), OCMockProjectReader.getFeatures(map), OCMockProjectReader.getCompilerSwitches(baseDir, map));
    }

    @Nullable
    private static Map<OCCompilerFeatures.Type<?>, ?> getFeatures(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object features = map.get("features");
        if (features == null) {
            return null;
        }
        assert (features instanceof Map) : "unexpected type for 'features', should be a map";
        LinkedHashMap<OCCompilerFeatures.Feature, Boolean> result = new LinkedHashMap<OCCompilerFeatures.Feature, Boolean>();
        for (Map.Entry eachEntry : ((Map)features).entrySet()) {
            String featureName = (String)eachEntry.getKey();
            try {
                OCCompilerFeatures.Feature feature = OCCompilerFeatures.Feature.valueOf((String)featureName);
                result.put(feature, (Boolean)eachEntry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unknown or unsupported compiler feature: " + featureName);
            }
        }
        return result;
    }

    @Nullable
    private static String getDefines(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object defines = map.get("defines");
        if (defines == null) {
            return null;
        }
        assert (defines instanceof Map) : "unexpected type for 'defines', should be a map";
        StringBuilder result = new StringBuilder();
        for (Map.Entry eachEntry : ((Map)defines).entrySet()) {
            result.append("#define ").append((String)eachEntry.getKey());
            if (eachEntry.getValue() != null) {
                result.append(" ").append(eachEntry.getValue());
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Nullable
    private static CidrCompilerSwitches getCompilerSwitches(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object compilerOptions = map.get("compilerArgs");
        if (compilerOptions == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        if (compilerOptions instanceof String) {
            options.add(OCMockProjectReader.replaceMacros(baseDir, (String)compilerOptions));
        } else {
            options.addAll(ContainerUtil.map((Collection)((List)compilerOptions), opt -> OCMockProjectReader.replaceMacros(baseDir, opt)));
        }
        return new CidrCompilerSwitches(options);
    }

    private static void readPCHOptions(@NotNull OCCompilerSettings.ModifiableModel settingsModel, @NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (map == null) {
            return;
        }
        Object args = map.get("pch");
        if (args == null) {
            return;
        }
        ArrayList<VirtualFile> pchFiles = new ArrayList<VirtualFile>(1);
        if (args instanceof String) {
            VirtualFile file2 = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{(String)args});
            if (OCLog.LOG.assertTrue(file2 != null, (Object)("cannot find PCH file: " + args))) {
                pchFiles.add(file2);
            }
        } else {
            for (String arg : (List)args) {
                VirtualFile file3 = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{arg});
                if (!OCLog.LOG.assertTrue(file3 != null, (Object)("cannot find PCH file: " + arg))) continue;
                pchFiles.add(file3);
            }
        }
        settingsModel.setImplicitIncludes(pchFiles);
    }

    private static void readSearchPaths(@NotNull OCCompilerSettings.ModifiableModel settingsModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        Object files = map.get("headers_paths");
        if (files == null) {
            return;
        }
        if (files instanceof List) {
            File baseDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            ArrayList<HeadersSearchPath> paths = new ArrayList<HeadersSearchPath>();
            for (Object eachEntry : (List)files) {
                String eachPath;
                boolean isRecursive = false;
                HeadersSearchPath.Kind kind = HeadersSearchPath.Kind.SYSTEM;
                boolean isFrameworks = false;
                boolean ensureExists = true;
                if (eachEntry instanceof String) {
                    eachPath = (String)eachEntry;
                } else {
                    Map entryMap = (Map)eachEntry;
                    if (entryMap.size() != 1) {
                        throw new RuntimeException("Unexpected entry in headers_paths: " + eachEntry);
                    }
                    Map.Entry item = entryMap.entrySet().iterator().next();
                    eachPath = (String)item.getKey();
                    Map attributes = (Map)item.getValue();
                    isRecursive = Boolean.TRUE.equals(attributes.get("recursive"));
                    kind = HeadersSearchPath.Kind.fromBoolean((boolean)Boolean.TRUE.equals(attributes.get("user")));
                    isFrameworks = Boolean.TRUE.equals(attributes.get("frameworks"));
                    ensureExists = !Boolean.FALSE.equals(attributes.get("ensureExists"));
                }
                VirtualFile file2 = baseDir.findFileByRelativePath(eachPath);
                if (ensureExists && file2 == null) {
                    throw new RuntimeException("Headers path " + eachPath + " not found in " + baseDir);
                }
                File path = file2 != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file2) : new File(baseDirPath, eachPath);
                paths.add(new HeadersSearchPath(path, isRecursive, kind, isFrameworks));
            }
            settingsModel.setHeadersSearchPaths(paths);
        }
    }

    private static boolean readGeneratedSources(@NotNull OCMockWorkspace workspace, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        return OCMockProjectReader.addFiles(baseDir, map.get("generated_sources"), (baseDirFile, eachRoot, fileAttrs) -> {
            if (!ContainerUtil.isEmpty((Map)fileAttrs)) {
                throw new NotImplementedError("No attributes are currently supported for generated_sources");
            }
            workspace.addGeneratedSourceFile(eachRoot);
            return true;
        });
    }

    private static boolean readFiles(@NotNull OCMockWorkspace workspace, @NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull OCMockWorkspace.CompilerSettingsData configCompilerSettings, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        return OCMockProjectReader.addFiles(baseDir, map.get("files"), (baseDirFile, eachFile, fileAttributes) -> {
            OCLanguageKind langKind;
            if (eachFile.isDirectory()) {
                return false;
            }
            OCLanguageKind forcedKind = null;
            if (fileAttributes != null) {
                forcedKind = OCMockProjectReader.languageById((String)fileAttributes.get("language"));
            }
            if ((langKind = workspace.addSourceFile(eachFile, forcedKind, configModel)) != null) {
                OCCompilerSettings.ModifiableModel settingsModel = configModel.getSourceCompilerSettings(eachFile);
                assert (settingsModel != null) : "Settings model could not be retrieved";
                if (fileAttributes != null) {
                    OCMockProjectReader.readSearchPaths(settingsModel, baseDirFile, fileAttributes);
                    OCMockProjectReader.readPCHOptions(settingsModel, baseDirFile, fileAttributes);
                }
                OCMockWorkspace.CompilerSettingsData fileCompilerSettings = OCMockProjectReader.getCompilerSettings(baseDir, fileAttributes);
                OCMockWorkspace.CompilerSettingsData mergedSettings = new OCMockWorkspace.CompilerSettingsData(fileCompilerSettings.defines != null ? fileCompilerSettings.defines : configCompilerSettings.defines, fileCompilerSettings.features != null ? fileCompilerSettings.features : configCompilerSettings.features, fileCompilerSettings.switches != null ? fileCompilerSettings.switches : configCompilerSettings.switches);
                OCMockWorkspace.applyDefinesAndFeatures(langKind, settingsModel, mergedSettings);
            }
            return true;
        });
    }

    private static OCLanguageKind languageById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case "c": {
                return CLanguageKind.C;
            }
            case "c++": {
                return CLanguageKind.CPP;
            }
            case "objc": {
                return CLanguageKind.OBJ_C;
            }
            case "objc++": {
                return CLanguageKind.OBJ_CPP;
            }
        }
        return null;
    }

    private static boolean addFiles(@NotNull VirtualFile baseDir, @Nullable Object files, @NotNull FileConsumer consumer) {
        if (files == null) {
            return false;
        }
        if (files instanceof List) {
            for (Object eachFileEntry : (List)files) {
                if (eachFileEntry instanceof Map) {
                    OCMockProjectReader.addFile(baseDir, (Map)eachFileEntry, consumer);
                    continue;
                }
                if (!(eachFileEntry instanceof String)) continue;
                OCMockProjectReader.addFile(baseDir, (String)eachFileEntry, null, consumer);
            }
        } else if (files instanceof String) {
            OCMockProjectReader.addFile(baseDir, (String)files, null, consumer);
        } else if (files instanceof Map) {
            OCMockProjectReader.addFile(baseDir, (Map)files, consumer);
        }
        return true;
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull Map<String, Map<String, Object>> entryMap, @NotNull FileConsumer consumer) {
        if (entryMap.size() != 1) {
            throw new RuntimeException("Unexpected entry in files: " + entryMap);
        }
        Map.Entry<String, Map<String, Object>> item = entryMap.entrySet().iterator().next();
        String eachFile = item.getKey();
        Map<String, Object> attributes = item.getValue();
        OCMockProjectReader.addFile(baseDir, eachFile, attributes, consumer);
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull String fileName, @Nullable Map<String, Object> fileAttrs, @NotNull FileConsumer consumer) {
        boolean[] found = new boolean[]{false};
        while (fileName.startsWith("../")) {
            fileName = fileName.substring(3);
            if ((baseDir = baseDir.getParent()) != null) continue;
            throw new RuntimeException(fileName + " not found, relative path is invalid");
        }
        String pattern = FileUtil.convertAntToRegexp((String)fileName);
        VirtualFile baseDirFile = baseDir;
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, eachFile -> {
            String relative = VfsUtilCore.getRelativePath((VirtualFile)eachFile, (VirtualFile)baseDirFile, (char)'/');
            assert (relative != null) : "Relative path could not be determined";
            if (relative.matches(pattern) && !FileUtilRt.extensionEquals((String)relative, (String)EXTENSION) && consumer.addFile(baseDirFile, (VirtualFile)eachFile, fileAttrs)) {
                found[0] = true;
            }
            return true;
        });
        if (!found[0]) {
            throw new RuntimeException(fileName + " not found in " + baseDir);
        }
    }

    @NotNull
    private static String replaceMacros(@NotNull VirtualFile baseDir, @NotNull String option) {
        if (option.contains("${BASE_DIR}")) {
            return option.replaceAll("\\$\\{BASE_DIR}", baseDir.getPath());
        }
        return option;
    }

    @FunctionalInterface
    private static interface FileConsumer {
        public boolean addFile(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @Nullable Map<String, Object> var3);
    }
}

