/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatedXmlNameImpl
implements EvaluatedXmlName {
    private static final Key<CachedValue<Map<String, List<String>>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"NamespaceProvider");
    private static final Map<EvaluatedXmlNameImpl, EvaluatedXmlNameImpl> ourInterned = new ConcurrentHashMap<EvaluatedXmlNameImpl, EvaluatedXmlNameImpl>();
    private final XmlName myXmlName;
    private final String myNamespaceKey;
    private final boolean myEqualToParent;

    private EvaluatedXmlNameImpl(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        this.myXmlName = xmlName;
        this.myNamespaceKey = namespaceKey;
        this.myEqualToParent = equalToParent;
    }

    @NotNull
    public final String getLocalName() {
        return this.myXmlName.getLocalName();
    }

    @Override
    public final XmlName getXmlName() {
        return this.myXmlName;
    }

    @Override
    public final EvaluatedXmlName evaluateChildName(@NotNull XmlName name) {
        String namespaceKey = name.getNamespaceKey();
        boolean equalToParent = Objects.equals(namespaceKey, this.myNamespaceKey);
        if (namespaceKey == null) {
            namespaceKey = this.myNamespaceKey;
        }
        return EvaluatedXmlNameImpl.createEvaluatedXmlName(name, namespaceKey, equalToParent);
    }

    public String toString() {
        return (this.myNamespaceKey == null ? "" : this.myNamespaceKey + " : ") + this.myXmlName.getLocalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvaluatedXmlNameImpl)) {
            return false;
        }
        EvaluatedXmlNameImpl that = (EvaluatedXmlNameImpl)o;
        if (this.myEqualToParent != that.myEqualToParent) {
            return false;
        }
        if (this.myNamespaceKey != null ? !this.myNamespaceKey.equals(that.myNamespaceKey) : that.myNamespaceKey != null) {
            return false;
        }
        return this.myXmlName.equals(that.myXmlName);
    }

    public int hashCode() {
        int result = this.myXmlName.hashCode();
        result = 31 * result + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
        result = 31 * result + (this.myEqualToParent ? 1 : 0);
        return result;
    }

    public final boolean isNamespaceAllowed(DomFileElement element, String namespace) {
        if (this.myNamespaceKey == null || this.myEqualToParent) {
            return true;
        }
        XmlFile file2 = element.getFile();
        return EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getAllowedNamespaces(file2));
    }

    @NotNull
    private List<String> getAllowedNamespaces(XmlFile file2) {
        CachedValue value = (CachedValue)file2.getUserData(NAMESPACE_PROVIDER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue(() -> {
                ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> {
                    DomFileDescription<?> description = DomManager.getDomManager(file2.getProject()).getDomFileDescription(file2);
                    if (description == null) {
                        return Collections.emptyList();
                    }
                    return description.getAllowedNamespaces((String)key, file2);
                });
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{file2});
            }, false);
            file2.putUserData(NAMESPACE_PROVIDER_KEY, (Object)value);
        }
        List list = (List)((Map)value.getValue()).get(this.myNamespaceKey);
        assert (list != null);
        return list;
    }

    private static boolean isNamespaceAllowed(String namespace, List<String> list) {
        return list.contains(namespace) || StringUtil.isEmpty((String)namespace) && list.isEmpty();
    }

    @Override
    public final boolean isNamespaceAllowed(String namespace, XmlFile file2, boolean qualified) {
        return this.myNamespaceKey == null || this.myEqualToParent && !qualified || EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getNamespaceList(file2));
    }

    @Override
    @NonNls
    @NotNull
    public final String getNamespace(@NotNull XmlElement parentElement, XmlFile file2) {
        List<String> strings;
        String xmlElementNamespace = EvaluatedXmlNameImpl.getXmlElementNamespace(parentElement);
        if (!(this.myNamespaceKey == null || this.myEqualToParent || (strings = this.getAllowedNamespaces(file2)).isEmpty() || strings.contains(xmlElementNamespace))) {
            return strings.get(0);
        }
        return xmlElementNamespace;
    }

    private static String getXmlElementNamespace(XmlElement parentElement) {
        if (parentElement instanceof XmlTag) {
            return ((XmlTag)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlAttribute) {
            return ((XmlAttribute)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlFile) {
            XmlTag tag;
            XmlDocument document = ((XmlFile)parentElement).getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                return tag.getNamespace();
            }
            return "";
        }
        throw new AssertionError((Object)("Can't get namespace of " + parentElement));
    }

    private List<String> getNamespaceList(XmlFile file2) {
        return this.getAllowedNamespaces(file2);
    }

    public static EvaluatedXmlNameImpl createEvaluatedXmlName(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        EvaluatedXmlNameImpl name = new EvaluatedXmlNameImpl(xmlName, namespaceKey, equalToParent);
        EvaluatedXmlNameImpl interned = ourInterned.get(name);
        if (interned != null) {
            return interned;
        }
        ourInterned.put(name, name);
        return name;
    }
}

