!macro CustomCodePreInstall
	${If} ${FileExists} "$INSTDIR\App\CudaText32\data"
		Rename "$INSTDIR\App\CudaText32\data" "$INSTDIR\App\CudaText\data"
		Rename "$INSTDIR\App\CudaText32\py" "$INSTDIR\App\CudaText\py"
		Rename "$INSTDIR\App\CudaText32\readme" "$INSTDIR\App\CudaText\readme"
		Rename "$INSTDIR\App\CudaText32\settings_default" "$INSTDIR\App\CudaText\settings_default"
		Rename "$INSTDIR\App\CudaText32\settings" "$INSTDIR\App\CudaText\settings"
	${EndIf}
	${If} ${FileExists} "$INSTDIR\App\AppInfo\appinfo.ini"
		ReadINIStr $0 "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		${VersionCompare} $0 "1.214.6.4" $R0
		${If} $R0 == 2
		${AndIf} ${FileExists} "$INSTDIR\App\CudaText\data"
		${AndIfNot} ${FileExists} "$INSTDIR\Data\CudaTextData"
			Rename "$INSTDIR\App\CudaText\data" "$INSTDIR\Data\CudaTextData"
		${EndIf}
	${EndIf}
	${If} ${FileExists} "$INSTDIR\App\AppInfo\appinfo.ini"
		ReadINIStr $0 "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		${VersionCompare} $0 "1.214.6.5" $R0
		${If} $R0 == 2
		${AndIf} ${FileExists} "$INSTDIR\App\CudaText\py"
		${AndIfNot} ${FileExists} "$INSTDIR\Data\CudaTextPy"
			Rename "$INSTDIR\App\CudaText\py" "$INSTDIR\Data\CudaTextPy"
		${EndIf}
	${EndIf}
	${If} ${FileExists} "$INSTDIR\Data\PortableApps.comLauncherRuntimeData-CudaTextPortable.ini"
		Rename "$INSTDIR\App\CudaText\py" "$INSTDIR\Data\CudaTextPy"
		Rename "$INSTDIR\App\CudaText\settings" "$INSTDIR\Data\CudaTextSettings"
		Rename "$INSTDIR\App\CudaText\data" "$INSTDIR\Data\CudaTextData"
		Delete "$INSTDIR\Data\PortableApps.comLauncherRuntimeData-CudaTextPortable.ini"
	${EndIf}
!macroend

!macro CustomCodePostInstall
	${If} ${FileExists} "$INSTDIR\Data\CudaTextData\*.*"
		CreateDirectory "$INSTDIR\Data\CudaTextData\lang"
		CopyFiles /SILENT "$INSTDIR\App\DefaultData\CudaTextData\lang\*.*" "$INSTDIR\Data\CudaTextData\lang"
		CreateDirectory "$INSTDIR\Data\CudaTextPy"
		CopyFiles /SILENT "$INSTDIR\App\DefaultData\CudaTextPy\*.*" "$INSTDIR\Data\CudaTextPy"
		CreateDirectory "$INSTDIR\Data\CudaTextSettings"
		CopyFiles /SILENT "$INSTDIR\App\DefaultData\CudaTextSettings\*.*" "$INSTDIR\Data\CudaTextSettings"
		ReadINIStr $1 "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		WriteINIStr "$INSTDIR\Data\settings\CudaTextPortableSettings.ini" "CudaTextPortableSettings" "DataVersion" $1
	${EndIf}
!macroend
