${SegmentFile}

${Segment.OnInit}
	; Borrowed the following from PAL 2.2, Remove on release of PAL 2.2
		; Work out if it's 64-bit or 32-bit
	System::Call kernel32::GetCurrentProcess()i.s
	System::Call kernel32::IsWow64Process(is,*i.r0)
	${If} $0 == 0
		StrCpy $Bits 32
		Rename "$EXEDIR\App\CudaText\py" "$EXEDIR\App\CudaText32\py"
		Rename "$EXEDIR\App\CudaText\readme" "$EXEDIR\App\CudaText32\readme"
		Rename "$EXEDIR\App\CudaText\settings_default" "$EXEDIR\App\CudaText32\settings_default"
	${Else}
		StrCpy $Bits 64
		Rename "$EXEDIR\App\CudaText32\py" "$EXEDIR\App\CudaText\py"
		Rename "$EXEDIR\App\CudaText32\readme" "$EXEDIR\App\CudaText\readme"
		Rename "$EXEDIR\App\CudaText32\settings_default" "$EXEDIR\App\CudaText\settings_default"
	${EndIf}
!macroend

${SegmentInit}
    ${If} $Bits = 64
        ${SetEnvironmentVariablesPath} FullAppDir "$EXEDIR\App\CudaText"
	${Else}
        ${SetEnvironmentVariablesPath} FullAppDir "$EXEDIR\App\CudaText32"
	${EndIf}
!macroend

${SegmentPre}
	ExpandEnvStrings $1 "%PAL:LastPortableAppsBaseDir%"
	${WordReplace} $1 "\" "|" "+" $2
	System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("PAL:LastPortableAppsBaseDir:Piped", "$2").r0'
	
	ExpandEnvStrings $1 "%PAL:PortableAppsBaseDir%"
	${WordReplace} $1 "\" "|" "+" $2
	System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("PAL:PortableAppsBaseDir:Piped", "$2").r0'
	
		ExpandEnvStrings $1 "%PAL:LastPackagePartialDir%"
	${WordReplace} $1 "\" "|" "+" $2
	System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("PAL:LastPackagePartialDir:Piped", "$2").r0'
	
	ExpandEnvStrings $1 "%PAL:PackagePartialDir%"
	${WordReplace} $1 "\" "|" "+" $2
	System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("PAL:PackagePartialDir:Piped", "$2").r0'
!macroend

${SegmentPrePrimary}
	${If} ${FileExists} "$EXEDIR\Data\settings\CudaTextPortableSettings.ini"
		ReadINIStr $0 "$EXEDIR\Data\settings\CudaTextPortableSettings.ini" "CudaTextPortableSettings" "DataVersion"
		ReadINIStr $1 "$EXEDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		${If} $0 != $1
			CopyFiles /SILENT "$EXEDIR\App\DefaultData\CudaTextData\lang\*.*" "$EXEDIR\Data\CudaTextData\lang"
			CopyFiles /SILENT "$EXEDIR\App\DefaultData\CudaTextPy\*.*" "$EXEDIR\Data\CudaTextPy"
			WriteINIStr "$EXEDIR\Data\settings\CudaTextPortableSettings.ini" "CudaTextPortableSettings" "DataVersion" $1
		${EndIf}
	${EndIf}
!macroend

${SegmentPostPrimary}
	ReadINIStr $0 "$EXEDIR\Data\settings\CudaTextPortableSettings.ini" "CudaTextPortableSettings" "DataVersion"
	ReadINIStr $1 "$EXEDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
	${If} $0 != $1
		WriteINIStr "$EXEDIR\Data\settings\CudaTextPortableSettings.ini" "CudaTextPortableSettings" "DataVersion" $1
	${EndIf}
!macroend
