/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.ObjectPool;

public class AesKeyWrap {
    private AesKeyWrap() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] wrap(DestroyableSecretKey kek, SecretKey key) {
        try (DestroyableSecretKey kekCopy = kek.copy();){
            ObjectPool.Lease<Cipher> cipher = CipherSupplier.RFC3394_KEYWRAP.keyWrapCipher(kekCopy);
            try {
                byte[] byArray = cipher.get().wrap(key);
                if (cipher != null) {
                    cipher.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (cipher != null) {
                    try {
                        cipher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (InvalidKeyException | IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Unable to wrap key.", e);
        }
    }

    public static DestroyableSecretKey unwrap(DestroyableSecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm) throws InvalidKeyException {
        return AesKeyWrap.unwrap(kek, wrappedKey, wrappedKeyAlgorithm, 3);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static DestroyableSecretKey unwrap(DestroyableSecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        try (DestroyableSecretKey kekCopy = kek.copy();){
            ObjectPool.Lease<Cipher> cipher = CipherSupplier.RFC3394_KEYWRAP.keyUnwrapCipher(kekCopy);
            try {
                DestroyableSecretKey destroyableSecretKey = DestroyableSecretKey.from(cipher.get().unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType));
                if (cipher != null) {
                    cipher.close();
                }
                return destroyableSecretKey;
            }
            catch (Throwable throwable) {
                if (cipher != null) {
                    try {
                        cipher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid algorithm: " + wrappedKeyAlgorithm, e);
        }
    }
}

