/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cryptomator.frontend.webdav.WebDavServerHandle;
import org.cryptomator.frontend.webdav.mount.AbstractMount;
import org.cryptomator.frontend.webdav.mount.AbstractMountBuilder;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=50)
@OperatingSystem(value=OperatingSystem.Value.LINUX)
public class LinuxGioMounter
implements MountService {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxGioMounter.class);
    private static final String WEBDAV_URI_SCHEME = "dav";
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private final Path gvfsMountDir;

    public LinuxGioMounter() {
        int uid;
        try {
            uid = (Integer)Files.getAttribute(USER_HOME, "unix:uid", new LinkOption[0]);
        }
        catch (IOException e) {
            uid = 0;
        }
        this.gvfsMountDir = Path.of("/run/user", String.valueOf(uid), "gvfs");
    }

    public String displayName() {
        return "WebDAV (gio)";
    }

    public boolean isSupported() {
        if (System.getenv().getOrDefault("XDG_CURRENT_DESKTOP", "").equals("KDE")) {
            return false;
        }
        if (!Files.isDirectory(this.gvfsMountDir, new LinkOption[0])) {
            return false;
        }
        try {
            ProcessBuilder checkDependenciesCmd = new ProcessBuilder("test", " `command -v gio`");
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(checkDependenciesCmd, 500L, TimeUnit.MILLISECONDS), 0);
            return true;
        }
        catch (IOException | TimeoutException e) {
            return false;
        }
    }

    public Set<MountCapability> capabilities() {
        return Set.of(MountCapability.LOOPBACK_PORT, MountCapability.MOUNT_TO_SYSTEM_CHOSEN_PATH, MountCapability.VOLUME_ID);
    }

    public int getDefaultLoopbackPort() {
        return 42427;
    }

    public MountBuilder forFileSystem(Path fileSystemRoot) {
        return new MountBuilderImpl(fileSystemRoot);
    }

    private class MountBuilderImpl
    extends AbstractMountBuilder {
        public MountBuilderImpl(Path vfsRoot) {
            super(vfsRoot);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Mount mount(WebDavServerHandle serverHandle, WebDavServletController servlet, URI uri) throws MountFailedException {
            try {
                URI schemeCorrectedUri = new URI(LinuxGioMounter.WEBDAV_URI_SCHEME, uri.getSchemeSpecificPart(), null);
                ProcessBuilder mountCmd = new ProcessBuilder("sh", "-c", "gio mount \"" + schemeCorrectedUri.toASCIIString() + "\"");
                Process mountProcess = mountCmd.start();
                ProcessUtil.waitFor(mountProcess, 30L, TimeUnit.SECONDS);
                ProcessUtil.assertExitValue(mountProcess, 0);
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(LinuxGioMounter.this.gvfsMountDir);){
                    Path mountPoint;
                    String dirName;
                    String encodedPath = URLEncoder.encode(schemeCorrectedUri.getRawPath(), StandardCharsets.UTF_8);
                    Iterator<Path> iterator = ds.iterator();
                    do {
                        if (!iterator.hasNext()) throw new MountFailedException("Mount succeeded, but failed to determine mount point within dir: " + String.valueOf(LinuxGioMounter.this.gvfsMountDir));
                    } while (!(dirName = (mountPoint = iterator.next()).getFileName().toString()).contains(schemeCorrectedUri.getHost()) || !dirName.contains(encodedPath));
                    LOG.debug("Mounted {} on {}.", (Object)schemeCorrectedUri.toASCIIString(), (Object)mountPoint);
                    MountImpl mountImpl = new MountImpl(serverHandle, servlet, mountPoint, schemeCorrectedUri);
                    return mountImpl;
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("URI constructed from elements known to be valid.", e);
            }
            catch (IOException | TimeoutException e) {
                throw new MountFailedException("Mounting failed", e);
            }
        }
    }

    private static class MountImpl
    extends AbstractMount {
        private final Path mountPoint;
        private final ProcessBuilder unmountCommand;
        private volatile boolean isMounted = true;

        public MountImpl(WebDavServerHandle serverHandle, WebDavServletController servlet, Path mountPoint, URI uri) {
            super(serverHandle, servlet);
            this.mountPoint = mountPoint;
            this.unmountCommand = new ProcessBuilder("sh", "-c", "gio mount -u \"" + uri.toASCIIString() + "\"");
        }

        public Mountpoint getMountpoint() {
            return Mountpoint.forPath((Path)this.mountPoint);
        }

        @Override
        public void unmount() throws UnmountFailedException {
            if (!this.isMounted) {
                return;
            }
            if (!Files.isDirectory(this.mountPoint, new LinkOption[0])) {
                LOG.debug("Volume already unmounted.");
            } else {
                try {
                    ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(this.unmountCommand, 10L, TimeUnit.SECONDS), 0);
                }
                catch (IOException | TimeoutException e) {
                    throw new UnmountFailedException(e);
                }
            }
            super.unmount();
            this.isMounted = false;
        }
    }
}

