/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v7;

import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptomator.cryptofs.migration.v7.InvalidOldFilenameException;
import org.cryptomator.cryptofs.migration.v7.UninflatableFileException;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;
import org.cryptomator.cryptolib.common.ObjectPool;

class FilePathMigration {
    private static final String OLD_SHORTENED_FILENAME_SUFFIX = ".lng";
    private static final Pattern OLD_SHORTENED_FILENAME_PATTERN = Pattern.compile("[A-Z2-7]{32}");
    private static final Pattern OLD_CANONICAL_FILENAME_PATTERN = Pattern.compile("(0|1S)?([A-Z2-7]{8})*[A-Z2-7=]{8}");
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    private static final BaseEncoding BASE64 = BaseEncoding.base64Url();
    private static final int SHORTENING_THRESHOLD = 220;
    private static final String OLD_DIRECTORY_PREFIX = "0";
    private static final String OLD_SYMLINK_PREFIX = "1S";
    private static final String NEW_REGULAR_SUFFIX = ".c9r";
    private static final String NEW_SHORTENED_SUFFIX = ".c9s";
    private static final int MAX_FILENAME_BUFFER_SIZE = 10240;
    private static final String NEW_SHORTENED_METADATA_FILE = "name.c9s";
    private static final String NEW_DIR_FILE = "dir.c9r";
    private static final String NEW_CONTENTS_FILE = "contents.c9r";
    private static final String NEW_SYMLINK_FILE = "symlink.c9r";
    private final Path oldPath;
    private final String oldCanonicalName;

    FilePathMigration(Path oldPath, String oldCanonicalName) {
        assert (OLD_CANONICAL_FILENAME_PATTERN.matcher(oldCanonicalName).matches());
        this.oldPath = oldPath;
        this.oldCanonicalName = oldCanonicalName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<FilePathMigration> parse(Path vaultRoot, Path oldPath) throws IOException {
        String canonicalOldFileName;
        String oldFileName = oldPath.getFileName().toString();
        if (oldFileName.endsWith(NEW_REGULAR_SUFFIX) || oldFileName.endsWith(NEW_SHORTENED_SUFFIX)) {
            return Optional.empty();
        }
        if (oldFileName.endsWith(OLD_SHORTENED_FILENAME_SUFFIX)) {
            Matcher matcher = OLD_SHORTENED_FILENAME_PATTERN.matcher(oldFileName);
            if (!matcher.find()) return Optional.empty();
            canonicalOldFileName = FilePathMigration.inflate(vaultRoot, matcher.group() + OLD_SHORTENED_FILENAME_SUFFIX);
            return Optional.of(new FilePathMigration(oldPath, canonicalOldFileName));
        } else {
            Matcher matcher = OLD_CANONICAL_FILENAME_PATTERN.matcher(oldFileName);
            if (!matcher.find()) return Optional.empty();
            canonicalOldFileName = matcher.group();
        }
        return Optional.of(new FilePathMigration(oldPath, canonicalOldFileName));
    }

    static String inflate(Path vaultRoot, String longFileName) throws UninflatableFileException {
        String string;
        block9: {
            Path metadataFilePath = vaultRoot.resolve("m/" + longFileName.substring(0, 2) + "/" + longFileName.substring(2, 4) + "/" + longFileName);
            SeekableByteChannel ch = Files.newByteChannel(metadataFilePath, StandardOpenOption.READ);
            try {
                if (ch.size() > 10240L) {
                    throw new UninflatableFileException("Unexpectedly large file: " + String.valueOf(metadataFilePath));
                }
                ByteBuffer buf = ByteBuffer.allocate((int)Math.min(ch.size(), 10240L));
                ch.read(buf);
                buf.flip();
                string = StandardCharsets.UTF_8.decode(buf).toString();
                if (ch == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Throwables.throwIfInstanceOf((Throwable)e, UninflatableFileException.class);
                    throw new UninflatableFileException("Failed to read metadata file " + String.valueOf(metadataFilePath), e);
                }
            }
            ch.close();
        }
        return string;
    }

    public Path migrate() throws IOException {
        String canonicalDeflatedName;
        String canonicalInflatedName = this.getNewInflatedName();
        boolean isShortened = !canonicalInflatedName.equals(canonicalDeflatedName = this.getNewDeflatedName());
        FileAlreadyExistsException attemptsExceeded = new FileAlreadyExistsException(this.oldPath.toString(), this.oldPath.resolveSibling(canonicalDeflatedName).toString(), "");
        Object attemptSuffix = "";
        for (int i = 1; i <= 3; ++i) {
            try {
                Path newPath = this.getTargetPath((String)attemptSuffix);
                if (isShortened || this.isDirectory() || this.isSymlink()) {
                    Files.createDirectory(newPath.getParent(), new FileAttribute[0]);
                }
                if (isShortened) {
                    Path metadataFilePath = newPath.resolveSibling(NEW_SHORTENED_METADATA_FILE);
                    Files.write(metadataFilePath, canonicalInflatedName.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                return Files.move(this.oldPath, newPath, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException e) {
                attemptSuffix = "_" + i;
                attemptsExceeded.addSuppressed(e);
                continue;
            }
        }
        throw attemptsExceeded;
    }

    Path getTargetPath(String attemptSuffix) throws InvalidOldFilenameException {
        String canonicalDeflatedName;
        String canonicalInflatedName = this.getNewInflatedName();
        boolean isShortened = !canonicalInflatedName.equals(canonicalDeflatedName = this.getNewDeflatedName());
        String inflatedName = canonicalInflatedName.substring(0, canonicalInflatedName.length() - NEW_REGULAR_SUFFIX.length()) + attemptSuffix + NEW_REGULAR_SUFFIX;
        String deflatedName = canonicalDeflatedName.substring(0, canonicalDeflatedName.length() - NEW_SHORTENED_SUFFIX.length()) + attemptSuffix + NEW_SHORTENED_SUFFIX;
        if (isShortened) {
            if (this.isDirectory()) {
                return this.oldPath.resolveSibling(deflatedName).resolve(NEW_DIR_FILE);
            }
            if (this.isSymlink()) {
                return this.oldPath.resolveSibling(deflatedName).resolve(NEW_SYMLINK_FILE);
            }
            return this.oldPath.resolveSibling(deflatedName).resolve(NEW_CONTENTS_FILE);
        }
        if (this.isDirectory()) {
            return this.oldPath.resolveSibling(inflatedName).resolve(NEW_DIR_FILE);
        }
        if (this.isSymlink()) {
            return this.oldPath.resolveSibling(inflatedName).resolve(NEW_SYMLINK_FILE);
        }
        return this.oldPath.resolveSibling(inflatedName);
    }

    public Path getOldPath() {
        return this.oldPath;
    }

    String getOldCanonicalName() {
        return this.oldCanonicalName;
    }

    String getOldCanonicalNameWithoutTypePrefix() {
        if (this.oldCanonicalName.startsWith(OLD_DIRECTORY_PREFIX)) {
            return this.oldCanonicalName.substring(OLD_DIRECTORY_PREFIX.length());
        }
        if (this.oldCanonicalName.startsWith(OLD_SYMLINK_PREFIX)) {
            return this.oldCanonicalName.substring(OLD_SYMLINK_PREFIX.length());
        }
        return this.oldCanonicalName;
    }

    String getNewInflatedName() throws InvalidOldFilenameException {
        byte[] decoded = this.getDecodedCiphertext();
        return BASE64.encode(decoded) + NEW_REGULAR_SUFFIX;
    }

    byte[] getDecodedCiphertext() throws InvalidOldFilenameException {
        String encodedCiphertext = this.getOldCanonicalNameWithoutTypePrefix();
        try {
            return BASE32.decode((CharSequence)encodedCiphertext);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOldFilenameException("Can't base32-decode '" + encodedCiphertext + "' in file " + this.oldPath.toString(), e);
        }
    }

    String getNewDeflatedName() throws InvalidOldFilenameException {
        String inflatedName = this.getNewInflatedName();
        if (inflatedName.length() > 220) {
            byte[] longFileNameBytes = inflatedName.getBytes(StandardCharsets.UTF_8);
            try (ObjectPool.Lease sha1 = MessageDigestSupplier.SHA1.instance();){
                byte[] hash = ((MessageDigest)sha1.get()).digest(longFileNameBytes);
                String string = BASE64.encode(hash) + NEW_SHORTENED_SUFFIX;
                return string;
            }
        }
        return inflatedName;
    }

    boolean isDirectory() {
        return this.oldCanonicalName.startsWith(OLD_DIRECTORY_PREFIX);
    }

    boolean isSymlink() {
        return this.oldCanonicalName.startsWith(OLD_SYMLINK_PREFIX);
    }
}

