/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.fh.BufferPool;
import org.cryptomator.cryptofs.fh.Chunk;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptolib.api.Cryptor;

@OpenFileScoped
class ChunkSaver {
    private final Cryptor cryptor;
    private final ChunkIO ciphertext;
    private final FileHeaderHolder headerHolder;
    private final CryptoFileSystemStats stats;
    private final BufferPool bufferPool;

    @Inject
    public ChunkSaver(Cryptor cryptor, ChunkIO ciphertext, FileHeaderHolder headerHolder, CryptoFileSystemStats stats, BufferPool bufferPool) {
        this.cryptor = cryptor;
        this.ciphertext = ciphertext;
        this.headerHolder = headerHolder;
        this.stats = stats;
        this.bufferPool = bufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(long chunkIndex, Chunk chunkData) throws IOException {
        if (chunkData.isDirty()) {
            long ciphertextPos = chunkIndex * (long)this.cryptor.fileContentCryptor().ciphertextChunkSize() + (long)this.cryptor.fileHeaderCryptor().headerSize();
            ByteBuffer cleartextBuf = chunkData.data().asReadOnlyBuffer();
            this.stats.addBytesEncrypted(cleartextBuf.remaining());
            ByteBuffer ciphertextBuf = this.bufferPool.getCiphertextBuffer();
            try {
                this.cryptor.fileContentCryptor().encryptChunk(cleartextBuf, ciphertextBuf, chunkIndex, this.headerHolder.get());
                ciphertextBuf.flip();
                this.ciphertext.write(ciphertextBuf, ciphertextPos);
                chunkData.dirty().set(false);
            }
            finally {
                this.bufferPool.recycle(ciphertextBuf);
            }
        }
    }
}

