/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileSystemCapabilityChecker {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemCapabilityChecker.class);
    private static final int MAX_CIPHERTEXT_NAME_LENGTH = 220;
    private static final int MIN_CIPHERTEXT_NAME_LENGTH = 28;
    private static final int MAX_ADDITIONAL_PATH_LENGTH = 48;

    @Inject
    public FileSystemCapabilityChecker() {
    }

    public void assertAllCapabilities(Path pathToVault) throws MissingCapabilityException {
        this.assertReadAccess(pathToVault);
        this.assertWriteAccess(pathToVault);
    }

    public void assertReadAccess(Path pathToVault) throws MissingCapabilityException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(pathToVault);){
            assert (ds != null);
        }
        catch (IOException e) {
            throw new MissingCapabilityException(pathToVault, Capability.READ_ACCESS);
        }
    }

    public void assertWriteAccess(Path pathToVault) throws MissingCapabilityException {
        Path checkDir = pathToVault.resolve("c");
        try {
            Files.createDirectories(checkDir, new FileAttribute[0]);
            Path tmpDir = Files.createTempDirectory(checkDir, "write-access", new FileAttribute[0]);
            Files.delete(tmpDir);
        }
        catch (IOException e) {
            throw new MissingCapabilityException(checkDir, Capability.WRITE_ACCESS);
        }
        finally {
            this.deleteRecursivelySilently(checkDir);
        }
    }

    public int determineSupportedCleartextFileNameLength(Path pathToVault) throws IOException {
        int maxCiphertextLen = this.determineSupportedCiphertextFileNameLength(pathToVault);
        assert (maxCiphertextLen >= 28);
        return (maxCiphertextLen - 4) / 4 * 3 - 16;
    }

    public int determineSupportedCiphertextFileNameLength(Path pathToVault) throws IOException {
        int subPathLength = 46;
        return this.determineSupportedCiphertextFileNameLength(pathToVault.resolve("c"), subPathLength, 28, 220);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int determineSupportedCiphertextFileNameLength(Path dir, int subPathLength, int minFileNameLength, int maxFileNameLength) throws IOException {
        Preconditions.checkArgument((subPathLength >= 6 ? 1 : 0) != 0, (Object)"subPathLength must be larger than charcount(a/nnn/)");
        Preconditions.checkArgument((minFileNameLength > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxFileNameLength <= 999 ? 1 : 0) != 0);
        String fillerName = Strings.repeat((String)"a", (int)(subPathLength - 5));
        assert (fillerName.length() > 0);
        Path fillerDir = dir.resolve(fillerName);
        try {
            Files.createDirectories(fillerDir.resolve("nnn"), new FileAttribute[0]);
            if (!this.canListDir(fillerDir)) {
                throw new IOException("Unable to read dir");
            }
            int n = this.determineSupportedCiphertextFileNameLength(fillerDir, minFileNameLength, maxFileNameLength + 1);
            return n;
        }
        finally {
            this.deleteRecursivelySilently(fillerDir);
        }
    }

    private int determineSupportedCiphertextFileNameLength(Path p, int lowerBoundIncl, int upperBoundExcl) {
        assert (lowerBoundIncl < upperBoundExcl);
        int mid = (lowerBoundIncl + upperBoundExcl) / 2;
        assert (mid < upperBoundExcl);
        if (mid == lowerBoundIncl) {
            return mid;
        }
        assert (lowerBoundIncl < mid);
        if (this.canHandleFileNameLength(p, mid)) {
            return this.determineSupportedCiphertextFileNameLength(p, mid, upperBoundExcl);
        }
        return this.determineSupportedCiphertextFileNameLength(p, lowerBoundIncl, mid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHandleFileNameLength(Path parent, int nameLength) {
        Path checkDir = parent.resolve(String.format("%03d", nameLength));
        Path checkFile = checkDir.resolve(Strings.repeat((String)"a", (int)nameLength));
        try {
            Files.createDirectories(checkDir, new FileAttribute[0]);
            try {
                Files.createFile(checkFile, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            boolean bl = this.canListDir(checkDir);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteSilently(checkFile);
            this.deleteRecursivelySilently(checkDir);
        }
    }

    private boolean canListDir(Path dir) {
        boolean bl;
        block8: {
            DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
            try {
                ds.iterator().hasNext();
                bl = true;
                if (ds == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ds != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | DirectoryIteratorException e) {
                    return false;
                }
            }
            ds.close();
        }
        return bl;
    }

    private void deleteSilently(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.trace("Failed to delete " + String.valueOf(path), (Throwable)e);
        }
    }

    private void deleteRecursivelySilently(Path dir) {
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                MoreFiles.deleteRecursively((Path)dir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }
        catch (IOException e) {
            LOG.trace("Failed to clean up " + String.valueOf(dir), (Throwable)e);
        }
    }

    public static class MissingCapabilityException
    extends FileSystemException {
        private final Capability missingCapability;

        public MissingCapabilityException(Path path, Capability missingCapability) {
            super(path.toString(), null, "Filesystem doesn't support " + String.valueOf((Object)missingCapability));
            this.missingCapability = missingCapability;
        }

        public Capability getMissingCapability() {
            return this.missingCapability;
        }
    }

    public static enum Capability {
        READ_ACCESS,
        WRITE_ACCESS;

    }
}

