/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CiphertextFilePath;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

@CryptoFileSystemScoped
public class Symlinks {
    private final CryptoPathMapper cryptoPathMapper;
    private final LongFileNameProvider longFileNameProvider;
    private final OpenCryptoFiles openCryptoFiles;
    private final ReadonlyFlag readonlyFlag;

    @Inject
    Symlinks(CryptoPathMapper cryptoPathMapper, LongFileNameProvider longFileNameProvider, OpenCryptoFiles openCryptoFiles, ReadonlyFlag readonlyFlag) {
        this.cryptoPathMapper = cryptoPathMapper;
        this.longFileNameProvider = longFileNameProvider;
        this.openCryptoFiles = openCryptoFiles;
        this.readonlyFlag = readonlyFlag;
    }

    public void createSymbolicLink(CryptoPath cleartextPath, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.cryptoPathMapper.assertNonExisting(cleartextPath);
        if (target.toString().length() > Short.MAX_VALUE) {
            throw new IOException("path length limit exceeded.");
        }
        CiphertextFilePath ciphertextFilePath = this.cryptoPathMapper.getCiphertextFilePath(cleartextPath);
        EffectiveOpenOptions openOptions = EffectiveOpenOptions.from(EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), this.readonlyFlag);
        ByteBuffer content = StandardCharsets.UTF_8.encode(target.toString());
        Files.createDirectory(ciphertextFilePath.getRawPath(), new FileAttribute[0]);
        this.openCryptoFiles.writeCiphertextFile(ciphertextFilePath.getSymlinkFilePath(), openOptions, content);
        ciphertextFilePath.persistLongFileName();
    }

    public CryptoPath readSymbolicLink(CryptoPath cleartextPath) throws IOException {
        Path ciphertextSymlinkFile = this.cryptoPathMapper.getCiphertextFilePath(cleartextPath).getSymlinkFilePath();
        EffectiveOpenOptions openOptions = EffectiveOpenOptions.from(EnumSet.of(StandardOpenOption.READ), this.readonlyFlag);
        this.assertIsSymlink(cleartextPath, ciphertextSymlinkFile);
        try {
            ByteBuffer content = this.openCryptoFiles.readCiphertextFile(ciphertextSymlinkFile, openOptions, Short.MAX_VALUE);
            return cleartextPath.getFileSystem().getPath(StandardCharsets.UTF_8.decode(content).toString(), new String[0]);
        }
        catch (BufferUnderflowException e) {
            throw new NotLinkException(cleartextPath.toString(), null, "Unreasonably large symlink file");
        }
    }

    private void assertIsSymlink(CryptoPath cleartextPath, Path ciphertextSymlinkFile) throws IOException {
        block4: {
            Path parentDir = ciphertextSymlinkFile.getParent();
            BasicFileAttributes parentAttr = Files.readAttributes(parentDir, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (parentAttr.isDirectory()) {
                try {
                    BasicFileAttributes fileAttr = Files.readAttributes(ciphertextSymlinkFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (!fileAttr.isRegularFile()) {
                        throw new NotLinkException(cleartextPath.toString(), null, "File exists but is not a symlink.");
                    }
                    break block4;
                }
                catch (NoSuchFileException e) {
                    throw new NotLinkException(cleartextPath.toString(), null, "File exists but is not a symlink.");
                }
            }
            throw new NotLinkException(cleartextPath.toString(), null, "File exists but is not a symlink.");
        }
    }

    public CryptoPath resolveRecursively(CryptoPath cleartextPath) throws IOException {
        return this.resolveRecursively(new HashSet<CryptoPath>(), cleartextPath);
    }

    private CryptoPath resolveRecursively(Set<CryptoPath> visitedLinks, CryptoPath cleartextPath) throws IOException {
        CiphertextFileType ciphertextFileType;
        if (visitedLinks.contains(cleartextPath)) {
            throw new FileSystemLoopException(cleartextPath.toString());
        }
        try {
            ciphertextFileType = this.cryptoPathMapper.getCiphertextFileType(cleartextPath);
        }
        catch (NoSuchFileException e) {
            return cleartextPath;
        }
        if (ciphertextFileType == CiphertextFileType.SYMLINK) {
            CryptoPath resolvedPath = this.readSymbolicLink(cleartextPath);
            visitedLinks.add(cleartextPath);
            return this.resolveRecursively(visitedLinks, resolvedPath);
        }
        return cleartextPath;
    }
}

