/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.mount;

import java.net.URI;
import java.nio.file.Path;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Mountpoint {
    public URI uri();

    public static Mountpoint forUri(URI uri) {
        return new WithUri(uri);
    }

    public static Mountpoint forPath(Path path) {
        return new WithPath(path);
    }

    public record WithUri(URI uri) implements Mountpoint
    {
    }

    public record WithPath(Path path) implements Mountpoint
    {
        @Override
        public URI uri() {
            return this.path.toUri();
        }
    }
}

