/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.List;

class ByteRange {
    private static final String RANGE_BYTE_PREFIX = "bytes=";
    private static final char RANGE_SET_SEP = ',';
    private static final char RANGE_SEP = '-';
    private final Long firstByte;
    private final Long lastByte;

    private ByteRange(Long firstByte, Long lastByte) throws MalformedByteRangeException {
        if (firstByte == null && lastByte == null || firstByte != null && lastByte != null && firstByte > lastByte) {
            throw new MalformedByteRangeException();
        }
        this.firstByte = firstByte;
        this.lastByte = lastByte;
    }

    public static ByteRange parse(String headerValue) throws UnsupportedRangeException, MalformedByteRangeException {
        if (!headerValue.startsWith(RANGE_BYTE_PREFIX)) {
            throw new UnsupportedRangeException();
        }
        String byteRangeStr = ByteRange.getSingleByteRange(headerValue);
        return ByteRange.getPositions(byteRangeStr);
    }

    private static String getSingleByteRange(String headerValue) throws UnsupportedRangeException, MalformedByteRangeException {
        String byteRangeSet = headerValue.substring(RANGE_BYTE_PREFIX.length());
        if (CharMatcher.whitespace().matchesAllOf((CharSequence)byteRangeSet)) {
            throw new MalformedByteRangeException();
        }
        List byteRanges = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)byteRangeSet);
        if (byteRanges.size() == 1) {
            return (String)byteRanges.get(0);
        }
        throw new UnsupportedRangeException();
    }

    private static ByteRange getPositions(String byteRangeStr) throws MalformedByteRangeException {
        List bytePos = Splitter.on((char)'-').splitToList((CharSequence)byteRangeStr);
        if (bytePos.size() != 2) {
            throw new MalformedByteRangeException();
        }
        try {
            Long first = ((String)bytePos.get(0)).isEmpty() ? null : Long.valueOf((String)bytePos.get(0));
            Long last = ((String)bytePos.get(1)).isEmpty() ? null : Long.valueOf((String)bytePos.get(1));
            return new ByteRange(first, last);
        }
        catch (NumberFormatException e) {
            throw new MalformedByteRangeException();
        }
    }

    public long getEffectiveFirstByte(long contentLength) {
        if (this.firstByte == null) {
            assert (this.lastByte != null);
            return Math.max(0L, contentLength - this.lastByte);
        }
        return this.firstByte;
    }

    public long getEffectiveLastByte(long contentLength) {
        if (this.firstByte == null || this.lastByte == null) {
            return contentLength - 1L;
        }
        return Math.min(this.lastByte, contentLength - 1L);
    }

    public static class MalformedByteRangeException
    extends Exception {
    }

    public static class UnsupportedRangeException
    extends Exception {
    }
}

