/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.cryptomator.frontend.fuse.mount.ProcessHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinfspUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WinfspUtil.class);
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REG_WINFSP_KEY = "HKLM\\SOFTWARE\\WOW6432Node\\WinFsp";
    private static final String REG_WINFSP_VALUE = "InstallDir";
    private static final AtomicReference<String> cache = new AtomicReference<Object>(null);

    private WinfspUtil() {
    }

    static String getWinFspInstallDir() throws WinFspNotFoundException {
        if (cache.get() == null) {
            cache.set(WinfspUtil.readWinFspInstallDirFromRegistry());
        }
        return cache.get();
    }

    static String readWinFspInstallDirFromRegistry() {
        try {
            ProcessBuilder command = new ProcessBuilder("reg", "query", REG_WINFSP_KEY, "/v", REG_WINFSP_VALUE);
            Process p = command.start();
            ProcessHelper.waitForSuccess(p, 3, "`reg query`");
            String result = p.inputReader(StandardCharsets.UTF_8).lines().filter(l -> l.contains(REG_WINFSP_VALUE)).findFirst().orElseThrow();
            return result.substring(result.indexOf(REGSTR_TOKEN) + REGSTR_TOKEN.length()).trim();
        }
        catch (IOException | TimeoutException | ProcessHelper.CommandFailedException e) {
            throw new WinFspNotFoundException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WinFspNotFoundException(e);
        }
    }

    static boolean isWinFspInstalled() {
        try {
            return Files.exists(Path.of(WinfspUtil.getWinFspInstallDir(), new String[0]), new LinkOption[0]);
        }
        catch (WinFspNotFoundException e) {
            return false;
        }
    }

    static class WinFspNotFoundException
    extends RuntimeException {
        public WinFspNotFoundException(Exception e) {
            super(e);
        }
    }
}

