/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import org.cryptomator.frontend.fuse.locks.DataLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PathLock(@Unmodifiable List<String> pathComponents, @Nullable PathLock parent, ReadWriteLock rwLock, Lock lock, Supplier<ReadWriteLock> dataLockSupplier) implements AutoCloseable
{
    private static final Logger LOG = LoggerFactory.getLogger(PathLock.class);

    @NotNull
    static PathLock readLock(List<String> pathComponents, @Nullable PathLock parent, ReadWriteLock rwLock, Supplier<ReadWriteLock> dataLockSupplier) {
        Lock lock = rwLock.readLock();
        lock.lock();
        LOG.trace("Acquired read path lock for '{}'", pathComponents);
        return new PathLock(pathComponents, parent, rwLock, lock, dataLockSupplier);
    }

    @NotNull
    static PathLock writeLock(List<String> pathComponents, @Nullable PathLock parent, ReadWriteLock rwLock, Supplier<ReadWriteLock> dataLockSupplier) {
        Lock lock = rwLock.writeLock();
        lock.lock();
        LOG.trace("Acquired write path lock for '{}'", pathComponents);
        return new PathLock(pathComponents, parent, rwLock, lock, dataLockSupplier);
    }

    @Nullable
    static PathLock tryWriteLock(List<String> pathComponents, @Nullable PathLock parent, ReadWriteLock rwLock, Supplier<ReadWriteLock> dataLockSupplier) {
        Lock lock = rwLock.writeLock();
        if (lock.tryLock()) {
            LOG.trace("Acquired write path lock for '{}'", pathComponents);
            return new PathLock(pathComponents, parent, rwLock, lock, dataLockSupplier);
        }
        return null;
    }

    public DataLock lockDataForReading() {
        ReadWriteLock dataLock = this.dataLockSupplier.get();
        return DataLock.readLock(this.pathComponents, dataLock);
    }

    public DataLock lockDataForWriting() {
        ReadWriteLock dataLock = this.dataLockSupplier.get();
        return DataLock.writeLock(this.pathComponents, dataLock);
    }

    @Override
    public void close() {
        LOG.trace("Released path lock for '{}'", this.pathComponents);
        this.lock.unlock();
        if (this.parent != null) {
            this.parent.close();
        }
    }

    @FunctionalInterface
    static interface Factory {
        @Nullable
        public PathLock lock(List<String> var1, @Nullable PathLock var2, ReadWriteLock var3, Supplier<ReadWriteLock> var4);
    }
}

