/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.stream.Stream;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.jfuse.api.DirFiller;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Stat;

public class ReadOnlyDirectoryHandler {
    private static final Path SAME_DIR = Paths.get(".", new String[0]);
    private static final Path PARENT_DIR = Paths.get("..", new String[0]);
    private final FileNameTranscoder fileNameTranscoder;

    public ReadOnlyDirectoryHandler(FileNameTranscoder fileNameTranscoder) {
        this.fileNameTranscoder = fileNameTranscoder;
    }

    public int getattr(Path path, BasicFileAttributes attrs, Stat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            stat.setPermissions(posixAttrs.permissions());
        } else {
            stat.setMode(365);
        }
        FileAttributesUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    public int readdir(Path path, DirFiller filler, long offset, FileInfo fi) throws IOException {
        int n;
        block9: {
            Stream<Path> ds = Files.list(path);
            try {
                Stream<Path> sameAndParent = Stream.of(SAME_DIR, PARENT_DIR);
                Stream<Path> iter = Stream.concat(sameAndParent, ds);
                for (Path file : iter.toList()) {
                    String fileName = file.getFileName().toString();
                    filler.fill(this.fileNameTranscoder.nioToFuse(fileName));
                }
                n = 0;
                if (ds == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ds != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    throw new IOException(e);
                }
            }
            ds.close();
        }
        return n;
    }
}

