/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(4096);

    public static void truncateOrExpand(FileChannel channel, long size) throws IOException {
        long currentSize = channel.size();
        if (size <= currentSize) {
            channel.truncate(size);
        } else {
            long remaining = size - currentSize;
            channel.position(currentSize);
            ByteBuffer buffer = BUFFER.duplicate();
            do {
                buffer.clear();
                int len = (int)Math.min(remaining, 4096L);
                buffer.limit(len);
            } while ((remaining -= (long)channel.write(buffer)) > 0L);
        }
    }
}

