/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.wrongfilealert;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javafx.application.Application;
import javafx.fxml.FXML;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.wrongfilealert.WrongFileAlertScoped;
import org.cryptomator.ui.wrongfilealert.WrongFileAlertWindow;

@WrongFileAlertScoped
public class WrongFileAlertController
implements FxController {
    private static final String DOCUMENTATION_URI = "https://docs.cryptomator.org/en/1.7/desktop/accessing-vaults/";
    private final Application app;
    private final Stage window;
    private Image screenshot;

    @Inject
    public WrongFileAlertController(@WrongFileAlertWindow Stage window, Application app) {
        this.window = window;
        this.app = app;
    }

    @FXML
    public void initialize() {
        String resource = SystemUtils.IS_OS_MAC ? "/img/vault-volume-mac.png" : "/img/vault-volume-win.png";
        try (InputStream in = this.getClass().getResourceAsStream(resource);){
            this.screenshot = new Image(in);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void openDocumentation() {
        this.app.getHostServices().showDocument(DOCUMENTATION_URI);
    }

    public Image getScreenshot() {
        return this.screenshot;
    }
}

