/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.preferences.PreferencesScoped;

@PreferencesScoped
public class UpdatesPreferencesController
implements FxController {
    private static final String DOWNLOADS_URI = "https://cryptomator.org/downloads";
    private final Application application;
    private final Environment environment;
    private final ResourceBundle resourceBundle;
    private final Settings settings;
    private final UpdateChecker updateChecker;
    private final ObjectBinding<ContentDisplay> checkForUpdatesButtonState;
    private final ReadOnlyStringProperty latestVersion;
    private final ObservableValue<Instant> lastSuccessfulUpdateCheck;
    private final StringBinding lastUpdateCheckMessage;
    private final ObservableValue<String> timeDifferenceMessage;
    private final String currentVersion;
    private final BooleanBinding updateAvailable;
    private final BooleanBinding checkFailed;
    private final BooleanProperty upToDateLabelVisible = new SimpleBooleanProperty(false);
    private final DateTimeFormatter formatter;
    private final BooleanBinding upToDate;
    public CheckBox checkForUpdatesCheckbox;

    @Inject
    UpdatesPreferencesController(Application application, Environment environment, ResourceBundle resourceBundle, Settings settings, UpdateChecker updateChecker) {
        this.application = application;
        this.environment = environment;
        this.resourceBundle = resourceBundle;
        this.settings = settings;
        this.updateChecker = updateChecker;
        this.checkForUpdatesButtonState = Bindings.when((ObservableBooleanValue)updateChecker.checkingForUpdatesProperty()).then((Object)ContentDisplay.LEFT).otherwise((Object)ContentDisplay.TEXT_ONLY);
        this.latestVersion = updateChecker.latestVersionProperty();
        this.lastSuccessfulUpdateCheck = updateChecker.lastSuccessfulUpdateCheckProperty();
        this.timeDifferenceMessage = Bindings.createStringBinding(this::getTimeDifferenceMessage, (Observable[])new Observable[]{this.lastSuccessfulUpdateCheck});
        this.currentVersion = updateChecker.getCurrentVersion();
        this.updateAvailable = updateChecker.updateAvailableProperty();
        this.formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.getDefault());
        this.upToDate = updateChecker.updateCheckStateProperty().isEqualTo((Object)UpdateChecker.UpdateCheckState.CHECK_SUCCESSFUL).and((ObservableBooleanValue)this.latestVersion.isEqualTo(this.currentVersion));
        this.checkFailed = updateChecker.checkFailedProperty();
        this.lastUpdateCheckMessage = Bindings.createStringBinding(this::getLastUpdateCheckMessage, (Observable[])new Observable[]{this.lastSuccessfulUpdateCheck});
    }

    public void initialize() {
        this.checkForUpdatesCheckbox.selectedProperty().bindBidirectional((Property)this.settings.checkForUpdates);
        this.upToDate.addListener((observableValue, bl, newVal) -> {
            if (newVal.booleanValue()) {
                this.upToDateLabelVisible.set(true);
                PauseTransition delay = new PauseTransition(Duration.seconds((double)5.0));
                delay.setOnFinished(actionEvent -> this.upToDateLabelVisible.set(false));
                delay.play();
            }
        });
    }

    @FXML
    public void checkNow() {
        this.updateChecker.checkForUpdatesNow();
    }

    @FXML
    public void visitDownloadsPage() {
        this.application.getHostServices().showDocument(DOWNLOADS_URI);
    }

    @FXML
    public void showLogfileDirectory() {
        this.environment.getLogDir().ifPresent(logDirPath -> this.application.getHostServices().showDocument(logDirPath.toUri().toString()));
    }

    public ObjectBinding<ContentDisplay> checkForUpdatesButtonStateProperty() {
        return this.checkForUpdatesButtonState;
    }

    public ContentDisplay getCheckForUpdatesButtonState() {
        return (ContentDisplay)this.checkForUpdatesButtonState.get();
    }

    public ReadOnlyStringProperty latestVersionProperty() {
        return this.latestVersion;
    }

    public String getLatestVersion() {
        return (String)this.latestVersion.get();
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public StringBinding lastUpdateCheckMessageProperty() {
        return this.lastUpdateCheckMessage;
    }

    public String getLastUpdateCheckMessage() {
        Instant lastCheck = (Instant)this.lastSuccessfulUpdateCheck.getValue();
        if (lastCheck != null && !lastCheck.equals(Settings.DEFAULT_TIMESTAMP)) {
            return this.formatter.format(LocalDateTime.ofInstant(lastCheck, ZoneId.systemDefault()));
        }
        return "-";
    }

    public ObservableValue<String> timeDifferenceMessageProperty() {
        return this.timeDifferenceMessage;
    }

    public String getTimeDifferenceMessage() {
        Instant lastSuccessCheck = (Instant)this.lastSuccessfulUpdateCheck.getValue();
        java.time.Duration duration = java.time.Duration.between(lastSuccessCheck, Instant.now());
        long hours = duration.toHours();
        if (lastSuccessCheck.equals(Settings.DEFAULT_TIMESTAMP)) {
            return this.resourceBundle.getString("preferences.updates.lastUpdateCheck.never");
        }
        if (hours < 1L) {
            return this.resourceBundle.getString("preferences.updates.lastUpdateCheck.recently");
        }
        if (hours < 24L) {
            return String.format(this.resourceBundle.getString("preferences.updates.lastUpdateCheck.hoursAgo"), hours);
        }
        return String.format(this.resourceBundle.getString("preferences.updates.lastUpdateCheck.daysAgo"), duration.toDays());
    }

    public BooleanProperty upToDateLabelVisibleProperty() {
        return this.upToDateLabelVisible;
    }

    public boolean isUpToDateLabelVisible() {
        return this.upToDateLabelVisible.get();
    }

    public BooleanBinding updateAvailableProperty() {
        return this.updateAvailable;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable.get();
    }

    public BooleanBinding checkFailedProperty() {
        return this.checkFailed;
    }

    public boolean isCheckFailed() {
        return this.checkFailed.getValue();
    }
}

