/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import dagger.Lazy;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultConfigCache;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.VaultConfigLoadException;
import org.cryptomator.cryptofs.VaultKeyInvalidException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.unlock.UnlockCancelledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckScoped
public class StartController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(StartController.class);
    private final Stage window;
    private final Stage unlockWindow;
    private final VaultConfigCache vaultConfig;
    private final KeyLoadingStrategy keyLoadingStrategy;
    private final ExecutorService executor;
    private final AtomicReference<Masterkey> masterkeyRef;
    private final AtomicReference<VaultConfig> vaultConfigRef;
    private final Lazy<Scene> checkScene;
    private final FxApplicationWindows appWindows;

    @Inject
    public StartController(@HealthCheckWindow Stage window, @HealthCheckWindow Vault vault, @HealthCheckWindow KeyLoadingStrategy keyLoadingStrategy, ExecutorService executor, AtomicReference<Masterkey> masterkeyRef, AtomicReference<VaultConfig> vaultConfigRef, @FxmlScene(value=FxmlFile.HEALTH_CHECK_LIST) Lazy<Scene> checkScene, FxApplicationWindows appWindows, @Named(value="unlockWindow") Stage unlockWindow) {
        this.window = window;
        this.unlockWindow = unlockWindow;
        this.vaultConfig = vault.getVaultConfigCache();
        this.keyLoadingStrategy = keyLoadingStrategy;
        this.executor = executor;
        this.masterkeyRef = masterkeyRef;
        this.vaultConfigRef = vaultConfigRef;
        this.checkScene = checkScene;
        this.appWindows = appWindows;
    }

    @FXML
    public void close() {
        LOG.trace("StartController.close()");
        this.window.close();
    }

    @FXML
    public void next() {
        LOG.trace("StartController.next()");
        CompletableFuture.runAsync(this::loadKey, this.executor).whenCompleteAsync(this::loadedKey, Platform::runLater);
    }

    private void loadKey() {
        assert (!Platform.isFxApplicationThread());
        try {
            this.keyLoadingStrategy.use(this::verifyVaultConfig);
        }
        catch (VaultConfigLoadException | UnlockCancelledException e) {
            throw new LoadingFailedException((Throwable)e);
        }
    }

    private void verifyVaultConfig(KeyLoadingStrategy keyLoadingStrategy) throws VaultConfigLoadException {
        VaultConfig.UnverifiedVaultConfig unverifiedCfg = this.vaultConfig.getUnchecked();
        try (Masterkey masterkey = keyLoadingStrategy.loadKey(unverifiedCfg.getKeyId());){
            VaultConfig verifiedCfg = unverifiedCfg.verify(masterkey.getEncoded(), unverifiedCfg.allegedVaultVersion());
            this.vaultConfigRef.set(verifiedCfg);
            Masterkey old = this.masterkeyRef.getAndSet(masterkey.copy());
            if (old != null) {
                old.destroy();
            }
        }
    }

    private void loadedKey(Void unused, Throwable exception) {
        assert (Platform.isFxApplicationThread());
        if (exception instanceof LoadingFailedException) {
            this.loadingKeyFailed(exception.getCause());
        } else if (exception != null) {
            this.loadingKeyFailed(exception);
        } else {
            LOG.debug("Loaded valid key");
            this.unlockWindow.close();
            this.window.setScene((Scene)this.checkScene.get());
        }
    }

    private void loadingKeyFailed(Throwable t) {
        Throwable throwable = t;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnlockCancelledException.class, VaultKeyInvalidException.class}, (Object)throwable2, n)) {
            case 0: {
                UnlockCancelledException e = (UnlockCancelledException)((Object)throwable2);
                break;
            }
            case 1: {
                VaultKeyInvalidException e = (VaultKeyInvalidException)throwable2;
                LOG.error("Invalid key");
                this.appWindows.showErrorWindow((Throwable)e, this.window, null);
                break;
            }
            default: {
                LOG.error("Failed to load key.", t);
                this.appWindows.showErrorWindow(t, this.window, null);
            }
        }
    }

    private static class LoadingFailedException
    extends CompletionException {
        LoadingFailedException(Throwable cause) {
            super(cause);
        }
    }
}

