/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.google.common.base.Throwables;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.application.Application;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.health.Result;

@HealthCheckScoped
public class ReportWriter {
    private static final String REPORT_HEADER = "*******************************************\n*     Cryptomator Vault Health Report     *\n*******************************************\nAnalyzed vault: %s (Current name \"%s\")\nVault storage path: %s\n";
    private static final String REPORT_CHECK_HEADER = "\n\nCheck %s\n------------------------------\n";
    private static final String REPORT_CHECK_RESULT = "%8s - %s\n";
    private static final DateTimeFormatter TIME_STAMP = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").withZone(ZoneId.systemDefault());
    private final Vault vault;
    private final VaultConfig vaultConfig;
    private final Application application;
    private final Path exportDestination;

    @Inject
    public ReportWriter(@HealthCheckWindow Vault vault, AtomicReference<VaultConfig> vaultConfigRef, Application application, Environment env) {
        this.vault = vault;
        this.vaultConfig = Objects.requireNonNull(vaultConfigRef.get());
        this.application = application;
        this.exportDestination = env.getLogDir().orElse(Path.of(System.getProperty("user.home"), new String[0])).resolve("healthReport_" + vault.getDisplayName() + "_" + TIME_STAMP.format(Instant.now()) + ".log");
    }

    protected void writeReport(Collection<Check> performedChecks) throws IOException {
        try (OutputStream out = Files.newOutputStream(this.exportDestination, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            writer.write(REPORT_HEADER.formatted(this.vaultConfig.getId(), this.vault.getDisplayName(), this.vault.getPath()));
            block16: for (Check check : performedChecks) {
                writer.write(REPORT_CHECK_HEADER.formatted(check.getHealthCheck().name()));
                switch (check.getState()) {
                    case SUCCEEDED: {
                        writer.write("STATUS: SUCCESS\nRESULTS:\n");
                        for (Result result : check.getResults()) {
                            writer.write(REPORT_CHECK_RESULT.formatted(result.diagnosis().getSeverity(), result.getDescription()));
                        }
                        continue block16;
                    }
                    case CANCELLED: {
                        writer.write("STATUS: CANCELED\n");
                        break;
                    }
                    case ERROR: {
                        writer.write("STATUS: FAILED\nREASON:\n");
                        writer.write(this.prepareFailureMsg(check));
                        break;
                    }
                    case RUNNABLE: 
                    case RUNNING: 
                    case SCHEDULED: {
                        throw new IllegalStateException("Checks are still running.");
                    }
                }
            }
        }
        this.reveal();
    }

    private String prepareFailureMsg(Check check) {
        if (check.getError() != null) {
            return Throwables.getStackTraceAsString((Throwable)check.getError()).lines().map(line -> "\t\t" + line + "\n").collect(Collectors.joining());
        }
        return "Unknown reason of failure.";
    }

    private void reveal() {
        this.application.getHostServices().showDocument(this.exportDestination.getParent().toUri().toString());
    }
}

