/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import com.google.common.base.Preconditions;
import java.awt.Desktop;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javax.inject.Inject;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.fxapp.ExitingQuitResponse;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class FxApplicationTerminator {
    private static final Set<VaultState.Value> STATES_ALLOWING_TERMINATION = EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.NEEDS_MIGRATION, VaultState.Value.MISSING, VaultState.Value.ERROR);
    private static final Set<VaultState.Value> STATES_PREVENT_TERMINATION = EnumSet.of(VaultState.Value.PROCESSING);
    private static final Logger LOG = LoggerFactory.getLogger(FxApplicationTerminator.class);
    private final ObservableList<Vault> vaults;
    private final ShutdownHook shutdownHook;
    private final FxApplicationWindows appWindows;
    private final AtomicBoolean allowQuitWithoutPrompt = new AtomicBoolean();
    private final AtomicBoolean preventQuitWithGracefulLock = new AtomicBoolean();
    private final Settings settings;
    private final VaultService vaultService;

    @Inject
    public FxApplicationTerminator(ObservableList<Vault> vaults, ShutdownHook shutdownHook, FxApplicationWindows appWindows, Settings settings, VaultService vaultService) {
        this.vaults = vaults;
        this.shutdownHook = shutdownHook;
        this.appWindows = appWindows;
        this.settings = settings;
        this.vaultService = vaultService;
    }

    public void initialize() {
        Preconditions.checkState((boolean)Desktop.isDesktopSupported(), (Object)"java.awt.Desktop not supported");
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler(this::handleQuitRequest);
        }
        if (desktop.isSupported(Desktop.Action.APP_QUIT_STRATEGY)) {
            desktop.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        }
        this.vaultListChanged((Observable)this.vaults);
        this.vaults.addListener(this::vaultListChanged);
        this.shutdownHook.runOnShutdown(this::forceUnmountRemainingVaults);
    }

    public void terminate() {
        this.handleQuitRequest(null, new NoopQuitResponse());
    }

    private void vaultListChanged(Observable observable) {
        boolean allowSuddenTermination = this.vaults.stream().map(Vault::getState).allMatch(STATES_ALLOWING_TERMINATION::contains);
        boolean stateChanged = this.allowQuitWithoutPrompt.compareAndSet(!allowSuddenTermination, allowSuddenTermination);
        boolean preventGracefulTermination = this.vaults.stream().map(Vault::getState).anyMatch(STATES_PREVENT_TERMINATION::contains);
        this.preventQuitWithGracefulLock.set(preventGracefulTermination);
        Desktop desktop = Desktop.getDesktop();
        if (stateChanged && desktop.isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
            if (allowSuddenTermination) {
                LOG.debug("Enabling sudden termination");
                desktop.enableSuddenTermination();
            } else {
                LOG.debug("Disabling sudden termination");
                desktop.disableSuddenTermination();
            }
        }
    }

    private void handleQuitRequest(@Nullable EventObject e, QuitResponse response) {
        ExitingQuitResponse exitingResponse = new ExitingQuitResponse(response);
        if (this.allowQuitWithoutPrompt.get()) {
            exitingResponse.performQuit();
        } else if (this.settings.autoCloseVaults.get() && !this.preventQuitWithGracefulLock.get()) {
            Task<Collection<Vault>> lockAllTask = this.vaultService.createLockAllTask((Collection<Vault>)this.vaults.filtered(Vault::isUnlocked), false);
            lockAllTask.setOnSucceeded(event -> {
                LOG.info("Locked remaining vaults was succesful.");
                exitingResponse.performQuit();
            });
            lockAllTask.setOnFailed(event -> {
                LOG.warn("Unable to lock all vaults.");
                this.appWindows.showQuitWindow(exitingResponse, true);
            });
            lockAllTask.run();
        } else {
            this.appWindows.showQuitWindow(exitingResponse, false);
        }
    }

    private void forceUnmountRemainingVaults() {
        for (Vault vault : this.vaults) {
            if (!vault.isUnlocked()) continue;
            try {
                vault.lock(true);
            }
            catch (IOException | UnmountFailedException e) {
                LOG.error("Failed to unmount vault " + String.valueOf(vault.getPath()), e);
            }
        }
    }

    private static class NoopQuitResponse
    implements QuitResponse {
        private NoopQuitResponse() {
        }

        @Override
        public void performQuit() {
        }

        @Override
        public void cancelQuit() {
        }
    }
}

