/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.jetbrains.annotations.VisibleForTesting;

@AddVaultWizardScoped
public class ReadmeGenerator {
    private static final String RTF_HEADER = "{\\rtf1\\fbidis\\ansi\\uc0\\fs32\n";
    private static final String RTF_FOOTER = "}";
    private static final String HEADING = "\\fs40\\qc %s";
    private static final String EMPTY_PAR = "";
    private static final String DONT_PAR = "\\b %s";
    private static final String IDENT_PAR = "    %s";
    private static final String HELP_URL = "{\\field{\\*\\fldinst HYPERLINK \"http://docs.cryptomator.org/\"}{\\fldrslt http://docs.cryptomator.org}}";
    private final ResourceBundle resourceBundle;

    @Inject
    public ReadmeGenerator(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String createVaultStorageLocationReadmeRtf() {
        return this.createDocument(List.of(String.format(HEADING, this.resourceBundle.getString("addvault.new.readme.storageLocation.1")), this.resourceBundle.getString("addvault.new.readme.storageLocation.2"), EMPTY_PAR, String.format(DONT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.3")), String.format(IDENT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.4")), String.format(IDENT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.5")), EMPTY_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.6"), String.format(IDENT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.7")), String.format(IDENT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.8")), String.format(IDENT_PAR, this.resourceBundle.getString("addvault.new.readme.storageLocation.9")), EMPTY_PAR, String.format(this.resourceBundle.getString("addvault.new.readme.storageLocation.10"), HELP_URL)));
    }

    public String createVaultAccessLocationReadmeRtf() {
        return this.createDocument(List.of(String.format(HEADING, this.resourceBundle.getString("addvault.new.readme.accessLocation.1")), this.resourceBundle.getString("addvault.new.readme.accessLocation.2"), EMPTY_PAR, this.resourceBundle.getString("addvault.new.readme.accessLocation.3"), EMPTY_PAR, this.resourceBundle.getString("addvault.new.readme.accessLocation.4")));
    }

    @VisibleForTesting
    String createDocument(Iterable<String> paragraphs) {
        StringBuilder sb = new StringBuilder(RTF_HEADER);
        for (String p : paragraphs) {
            sb.append("{\\sa80 ");
            this.appendEscaped(sb, p);
            sb.append("}\\par \n");
        }
        sb.append(RTF_FOOTER);
        return sb.toString();
    }

    @VisibleForTesting
    String escapeNonAsciiChars(CharSequence input) {
        StringBuilder sb = new StringBuilder();
        this.appendEscaped(sb, input);
        return sb.toString();
    }

    private void appendEscaped(StringBuilder sb, CharSequence input) {
        input.chars().forEachOrdered(c -> {
            if (c < 128) {
                sb.append((char)c);
            } else if (c < 65535) {
                sb.append("\\u").append(c);
            }
        });
    }
}

