/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;

@AddVaultWizardScoped
public class CreateNewVaultNameController
implements FxController {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[\\w -]+", 256);
    public TextField textField;
    private final Stage window;
    private final Lazy<Scene> chooseLocationScene;
    private final ObjectProperty<Path> vaultPath;
    private final StringProperty vaultName;
    private final BooleanBinding validVaultName;

    @Inject
    CreateNewVaultNameController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_LOCATION) Lazy<Scene> chooseLocationScene, ObjectProperty<Path> vaultPath, @Named(value="vaultName") StringProperty vaultName) {
        this.window = window;
        this.chooseLocationScene = chooseLocationScene;
        this.vaultPath = vaultPath;
        this.vaultName = vaultName;
        this.validVaultName = Bindings.createBooleanBinding(this::isValidVaultName, (Observable[])new Observable[]{vaultName});
    }

    @FXML
    public void initialize() {
        this.vaultName.bindBidirectional((Property)this.textField.textProperty());
        this.vaultName.addListener(this::vaultNameChanged);
    }

    private void vaultNameChanged(Observable observable) {
        if (this.isValidVaultName() && this.vaultPath.get() != null) {
            this.vaultPath.set((Object)((Path)this.vaultPath.get()).resolveSibling((String)this.vaultName.get()));
        }
    }

    @FXML
    public void next() {
        this.window.setScene((Scene)this.chooseLocationScene.get());
        this.vaultName.set((Object)((String)this.vaultName.get()).trim());
    }

    public BooleanBinding validVaultNameProperty() {
        return this.validVaultName;
    }

    public boolean isValidVaultName() {
        return this.vaultName.get() != null && VALID_NAME_PATTERN.matcher(((String)this.vaultName.get()).trim()).matches();
    }
}

