/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.addvaultwizard.AddVaultSuccessController;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.addvaultwizard.ChooseExistingVaultController;
import org.cryptomator.ui.addvaultwizard.CreateNewVaultExpertSettingsController;
import org.cryptomator.ui.addvaultwizard.CreateNewVaultLocationController;
import org.cryptomator.ui.addvaultwizard.CreateNewVaultNameController;
import org.cryptomator.ui.addvaultwizard.CreateNewVaultPasswordController;
import org.cryptomator.ui.addvaultwizard.CreateNewVaultRecoveryKeyController;
import org.cryptomator.ui.changepassword.NewPasswordController;
import org.cryptomator.ui.changepassword.PasswordStrengthUtil;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.fxapp.PrimaryStage;
import org.cryptomator.ui.recoverykey.RecoveryKeyDisplayController;

@Module
public abstract class AddVaultModule {
    @Provides
    @AddVaultWizardWindow
    @AddVaultWizardScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @AddVaultWizardWindow
    @AddVaultWizardScoped
    static Stage provideStage(StageFactory factory, @PrimaryStage Stage primaryStage) {
        Stage stage = factory.create();
        stage.setResizable(false);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)primaryStage);
        return stage;
    }

    @Provides
    @AddVaultWizardScoped
    static ObjectProperty<Path> provideVaultPath() {
        return new SimpleObjectProperty();
    }

    @Provides
    @Named(value="vaultName")
    @AddVaultWizardScoped
    static StringProperty provideVaultName() {
        return new SimpleStringProperty("");
    }

    @Provides
    @Named(value="shorteningThreshold")
    @AddVaultWizardScoped
    static IntegerProperty provideShorteningThreshold() {
        return new SimpleIntegerProperty(220);
    }

    @Provides
    @AddVaultWizardWindow
    @AddVaultWizardScoped
    static ObjectProperty<Vault> provideVault() {
        return new SimpleObjectProperty();
    }

    @Provides
    @Named(value="recoveryKey")
    @AddVaultWizardScoped
    static StringProperty provideRecoveryKey() {
        return new SimpleStringProperty();
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_EXISTING)
    @AddVaultWizardScoped
    static Scene provideChooseExistingVaultScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_EXISTING);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_NEW_NAME)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultNameScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_NEW_NAME);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_NEW_LOCATION)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultLocationScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_NEW_LOCATION);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_NEW_PASSWORD)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultPasswordScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_NEW_PASSWORD);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_NEW_RECOVERYKEY)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultRecoveryKeyScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_NEW_RECOVERYKEY);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_SUCCESS)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultSuccessScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_SUCCESS);
    }

    @Provides
    @FxmlScene(value=FxmlFile.ADDVAULT_NEW_EXPERT_SETTINGS)
    @AddVaultWizardScoped
    static Scene provideCreateNewVaultExpertSettingsScene(@AddVaultWizardWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.ADDVAULT_NEW_EXPERT_SETTINGS);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=ChooseExistingVaultController.class)
    abstract FxController bindChooseExistingVaultController(ChooseExistingVaultController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CreateNewVaultNameController.class)
    abstract FxController bindCreateNewVaultNameController(CreateNewVaultNameController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CreateNewVaultLocationController.class)
    abstract FxController bindCreateNewVaultLocationController(CreateNewVaultLocationController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CreateNewVaultPasswordController.class)
    abstract FxController bindCreateNewVaultPasswordController(CreateNewVaultPasswordController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=NewPasswordController.class)
    static FxController provideNewPasswordController(ResourceBundle resourceBundle, PasswordStrengthUtil strengthRater) {
        return new NewPasswordController(resourceBundle, strengthRater);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=CreateNewVaultRecoveryKeyController.class)
    abstract FxController bindCreateNewVaultRecoveryKeyController(CreateNewVaultRecoveryKeyController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=RecoveryKeyDisplayController.class)
    static FxController provideRecoveryKeyDisplayController(@AddVaultWizardWindow Stage window, @Named(value="vaultName") StringProperty vaultName, @Named(value="recoveryKey") StringProperty recoveryKey, ResourceBundle localization) {
        return new RecoveryKeyDisplayController(window, (String)vaultName.get(), (String)recoveryKey.get(), localization);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=AddVaultSuccessController.class)
    abstract FxController bindAddVaultSuccessController(AddVaultSuccessController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CreateNewVaultExpertSettingsController.class)
    abstract FxController bindCreateNewVaultExpertSettingsController(CreateNewVaultExpertSettingsController var1);
}

